define('CloseButton', [
  'backbone', 'template-store-singleton'
], function (Backbone, templateStore) {
  'use strict';

  var CloseButton = Backbone.View.extend({

    className: 'fv-close-button',

    events: {
      'click': '_close'
    },

    tagName: 'span',

    initialize: function (options) {
      this._fileViewer = options.fileViewer;
    },

    render: function () {
      this.$el.html(templateStore.get('controlCloseButton')());

      this.$('button').tooltip({ gravity: 'n' });

      return this;
    },

    _close: function (e) {
      e.preventDefault();
      this._fileViewer.analytics.send('files.fileviewer-web.closed', {
        actionType: 'button'
      });
      this._fileViewer.close();
    }
  });

  return CloseButton;
});
