(function () {
    'use strict';

    var $ = require('jquery');
    var FileViewer = require('file-viewer');

    module('BaseViewer');

    test('clicking the background sends an analytics event', function () {
        // given
        var file = {src: 'test', type:'test/example'};
        var hasher = function (x) { return x.toUpperCase() };
        var backend = sinon.spy();
        var fileViewer = new FileViewer({ analyticsBackend:backend, appendTo: $('<div>') });
        fileViewer.analytics._hasher = hasher;

        // when
        fileViewer.open();
        fileViewer.updateFiles([file]);

        fileViewer.showFileWithQuery({src: file.src});
        fileViewer.getView().$('#cp-unknown-file-type-view-wrapper').mousedown().click();

        // then
        ok(backend.calledOnce);
        var key = backend.args[0][0];
        var data = backend.args[0][1];
        equal(key, 'files.fileviewer-web.closed');
        equal(data.actionType, 'element');
        equal(data.fileType, file.type);
        equal(data.fileId, hasher(file.src));
        equal(data.fileState, 'success');
    });

}());