!function(){"use strict";var _modules={},define=function(name,dependencies,factoryFn){_modules[name]={deps:dependencies,factory:factoryFn,value:null}},require=function(name,mocks){var module=require._normalizeMocks(mocks)[name]||_modules[name];if(!module)throw new Error("module not found "+name);return module.value||(module.value=module.factory.apply(null,module.deps.map(function(name){return require(name,mocks)}))),module.value};require._normalizeMocks=function(mocks){if(!mocks)return{};var normalizedMocks={};return Object.keys(mocks).forEach(function(key){normalizedMocks[key]={deps:[],factory:function(){return mocks[key]},value:null}}),normalizedMocks},define("jquery",[],function(){return jQuery}),define("underscore",[],function(){return _}),define("backbone",[],function(){return Backbone}),define("ajs",[],function(){return AJS}),define("3d-view-provider",["jquery"],function($){var threeDViewProvider=function(){return $.Deferred().resolve(require("3d-view"))};return threeDViewProvider}),define("Analytics",["underscore"],function(_){var Analytics=function(backend,fileViewer,hasher){this._backend=backend,this._fileViewer=fileViewer,this._hasher=hasher};return Analytics.prototype.send=function(key,data){if(this._backend){var file=this._fileViewer.getCurrentFile(),attributes=file&&file.attributes||{},augmentedData=_.extend({fileType:attributes.type,fileId:this._hasher(attributes.src||""),fileState:this._fileViewer.getView().getViewState()},data);this._backend(key,augmentedData)}},Analytics.prototype.fn=function(key,data){return this.send.bind(this,key,data)},Analytics}),define("ArrowLayer",["backbone","template-store-singleton"],function(Backbone,templateStore){var AJS=window.AJS,ArrowLayer=Backbone.View.extend({className:"cp-arrow-layer",events:{"click #cp-nav-left:not(.disabled)":"gotoPrevious","click #cp-nav-right:not(.disabled)":"gotoNext"},initialize:function(options){this._fileViewer=options.fileViewer,this.listenTo(this._fileViewer._fileState.collection,"add reset",this.checkAndHideNavigation),this._visibleArrows=!1,this._updateElements()},render:function(){return this.$el.html(templateStore.get("fileBodyArrows")()).hide(),this._updateElements(),this.checkAndHideNavigation(),this},gotoNext:function(){this._fileViewer.showFileNext().always(this._fileViewer.analytics.fn("files.fileviewer-web.next",{actionType:"button",mode:this._fileViewer.getMode()}))},gotoPrevious:function(){this._fileViewer.showFilePrev().always(this._fileViewer.analytics.fn("files.fileviewer-web.prev",{actionType:"button",mode:this._fileViewer.getMode()}))},enableArrow:function($arrow){$arrow.removeClass("disabled"),$arrow.removeAttr("original-title")},disableArrow:function(options){options.arrow.addClass("disabled"),options.arrow.attr("original-title",options.tooltipText),options.arrow.tooltip({gravity:options.tooltipGravity})},showsArrow:function(){return this._visibleArrows},checkAndHideNavigation:function(){return this._fileViewer._fileState.collection.length<=1?(this._visibleArrows=!1,this.$arrows.hide()):(this.$arrows.show(),this._visibleArrows=!0,void(this._fileViewer.getConfig().enableListLoop||(this._fileViewer.isShowingLastFile()?this.disableArrow({arrow:this.$arrowRight,tooltipText:AJS.I18n.getText("cp.arrow.right.disabled"),tooltipGravity:"e"}):this._fileViewer.isShowingFirstFile()&&this.disableArrow({arrow:this.$arrowLeft,tooltipText:AJS.I18n.getText("cp.arrow.left.disabled"),tooltipGravity:"w"}))))},_updateElements:function(){this.$arrows=this.$el.find(".cp-nav"),this.$arrowLeft=this.$el.find("#cp-nav-left"),this.$arrowRight=this.$el.find("#cp-nav-right")}});return ArrowLayer}),define("assert",[],function(){var assert=function(predicate,description){if(description=description||"untruthy value",!predicate)throw new Error("Assertion failed: "+description)};return assert}),define("asset-module-backend",[],function(){return function(fileViewer){return function(moduleName){return"pdf-config"===moduleName?fileViewer.getConfig().assets["pdf-config"]||{}:void 0}}}),define("baseMode",["jquery","keyboard"],function($,keyboard){var AJS=window.AJS,baseMode={activateHook:function(mainView){mainView.$el.on("click #cp-file-body",mainView._onClickToBackground.bind(mainView));var $arrowLayer=mainView.fileContentView.getLayerForName("arrows").$el;$arrowLayer.toggle(this.showsArrowLayer)},deactivateHook:function(mainView){mainView.$el.off("click #cp-file-body")},setup:function(mainView,viewer){viewer&&viewer.$el.on("click.contentView",viewer._clickedBackgroundToClose.bind(viewer)),$(document).on("keydown.modeKeys",this._handleKeys.bind(mainView))},teardown:function(mainView,viewer){viewer&&viewer.$el.off("click.contentView"),$(document).off("keydown.modeKeys")},showsArrowLayer:!0,_handleKeys:function(e){var contentView,viewer;this.fileContentView.isLayerInitialized("content")&&(contentView=this.fileContentView.getLayerForName("content"),viewer=contentView.getAttachedViewer()),viewer&&(e.ctrlKey||e.metaKey)&&(e.which!==keyboard.keys.PLUS&&e.which!==keyboard.keys.PLUS_NUMPAD&&e.which!==keyboard.keys.PLUS_FF||(viewer.zoomIn&&(this._fileViewer.analytics.send("files.fileviewer-web.file.zoomin",{actionType:"hotkey"}),viewer.zoomIn()),e.preventDefault()),e.which!==keyboard.keys.MINUS&&e.which!==keyboard.keys.MINUS_NUMPAD&&e.which!==keyboard.keys.MINUS_FF||(viewer.zoomOut&&(this._fileViewer.analytics.send("files.fileviewer-web.file.zoomout",{actionType:"hotkey"}),viewer.zoomOut()),e.preventDefault()))},toolbarActions:[{title:AJS.I18n.getText("cp.zoom.out"),className:"cp-toolbar-minus",predicate:function(){return this._viewer&&this._viewer.zoomOut},handler:function(){this._viewer&&this._viewer.zoomOut&&(this._fileViewer.analytics.send("files.fileviewer-web.file.zoomout",{actionType:"button"}),this._viewer.zoomOut())}},{title:AJS.I18n.getText("cp.zoom.in"),className:"cp-toolbar-plus",predicate:function(){return this._viewer&&this._viewer.zoomIn},handler:function(){this._viewer&&this._viewer.zoomIn&&(this._fileViewer.analytics.send("files.fileviewer-web.file.zoomin",{actionType:"button"}),this._viewer.zoomIn())}},{title:AJS.I18n.getText("cp.fit.to.page"),className:"cp-toolbar-fit",predicate:function(){return this._viewer&&this._viewer.zoomFit},handler:function(){this._viewer&&this._viewer.zoomFit&&(this._fileViewer.analytics.send("files.fileviewer-web.file.zoomfit",{actionType:"button"}),this._viewer.zoomFit())}},{title:AJS.I18n.getText("cp.enter.presentation.mode"),className:"cp-toolbar-presentation",predicate:function(){return this._viewer&&this._fileViewer.getConfig().enablePresentationMode},handler:function(){this._fileViewer.analytics.send("files.fileviewer-web.presentation.enter"),this._fileViewer.changeMode("PRESENTATION")}}]};return baseMode}),define("BaseViewer",["jquery","underscore","backbone"],function($,_,Backbone){var BaseViewer=Backbone.View.extend({contentViewEvents:{"click.contentView":"_clickedBackgroundToClose","mousedown.contentView":"_mousedownContentView"},initialize:function(options){this.events=_.extend(this.events||{},this.contentViewEvents),this._fileViewer=options.fileViewer,this._previewSrc=options.previewSrc,this._mousedownBackground=null},teardown:function(){},_mousedownContentView:function(e){var $background=this.getBackground?this.getBackground():this.$el;this._mousedownBackground=$(e.target).is($background)},_clickedBackgroundToClose:function(e){var mode=this._fileViewer._view._modes[this._fileViewer._view._mode];if(!mode.disableClickBackgroundCloses){var $background=this.getBackground?this.getBackground():this.$el;this._mousedownBackground&&$(e.target).is($background)&&(this._fileViewer.analytics.send("files.fileviewer-web.closed",{actionType:"element"}),this._fileViewer.close())}},handleResize:function(){}});return BaseViewer}),define("CloseButton",["backbone","template-store-singleton"],function(Backbone,templateStore){var CloseButton=Backbone.View.extend({className:"fv-close-button",events:{click:"_close"},tagName:"span",initialize:function(options){this._fileViewer=options.fileViewer},render:function(){return this.$el.html(templateStore.get("controlCloseButton")()),this.$("button").tooltip({gravity:"n"}),this},_close:function(e){e.preventDefault(),this._fileViewer.analytics.send("files.fileviewer-web.closed",{actionType:"button"}),this._fileViewer.close()}});return CloseButton}),define("Commands",["jquery","ajs","file"],function($,AJS,File){var rejectWithError=function(msg){return(new $.Deferred).reject(new Error(msg)).promise()},Commands={};return Commands.LookupViewer=function(originalFile,viewerRegistry){this._originalFile=originalFile,this._viewerRegistry=viewerRegistry},Commands.LookupViewer.prototype.execute=function(previewSrc,previewType,overwrites){var convertedFile=new File(this._originalFile.toJSON());convertedFile.set(overwrites),convertedFile.set("type",previewType),convertedFile.set("src",previewSrc);var loadViewer=this._viewerRegistry.get(previewType);if(!loadViewer)return rejectWithError(AJS.I18n.getText("cp.error.file.no.viewer"));var dfd=$.Deferred();return loadViewer().then(function(Viewer){dfd.resolve(Viewer,previewSrc,convertedFile)}).fail(function(){dfd.fail(arguments)}),dfd.promise()},Commands}),define("defaultConfig",[],function(){return{enableListLoop:!0,enablePresentationMode:!0,preloadImagesAfterCurrent:2,preloadImagesBeforeCurrent:0,videoDefaultQualityHd:!0,customStorage:null,viewers:["image","document","video","3d"],embedded:!1}}),define("constants-dictionary",["assert"],function(assert){var ConstantsDictionary=function(){this._valuesByName={},this._names=[]};return ConstantsDictionary.prototype.define=function(name,value){assert(!this.isDefined(name),"name is unique"),this._valuesByName[name]=value,this._names.push(name)},ConstantsDictionary.prototype.lookup=function(name){return assert(this.isDefined(name),"name is defined"),this._valuesByName[name]},ConstantsDictionary.prototype.isDefined=function(name){return name in this._valuesByName},ConstantsDictionary.prototype.list=function(){return this._names.map(function(name){return{name:name,value:this._valuesByName[name]}},this)},ConstantsDictionary}),define("djb2",[],function(){var toCharCode=function(str){return str.charCodeAt(0)},updateHash=function(prev,curr){return(prev<<5)+prev+curr},djb2=function(str){return str.split("").map(toCharCode).reduce(updateHash,5381)};return djb2}),define("DownloadButton",["backbone","template-store-singleton"],function(Backbone,templateStore){var DownloadButton=Backbone.View.extend({tagName:"span",events:{click:"_triggerAnalytics"},initialize:function(options){this._fileViewer=options.fileViewer,this._model=this._fileViewer.getCurrentFile()},render:function(){return this.$el.html(templateStore.get("controlDownloadButton")({src:this._model.get("srcDownload")||this._model.get("src")})),this.$("a").tooltip({gravity:"n"}),this},_triggerAnalytics:function(){this._fileViewer.trigger("fv.download"),this._fileViewer.analytics.send("files.fileviewer-web.file.download",{actionType:"button"})}},{isDownloadable:function(fileViewer){var file=fileViewer.getCurrentFile();return file&&file.get("downloadable")}});return DownloadButton}),define("ErrorLayer",["ajs","backbone","template-store-singleton"],function(AJS,Backbone,templateStore){var ErrorLayer=Backbone.View.extend({className:"cp-error-layer",initialize:function(){this.$el.hide()},showErrorMessage:function(err,file){var title,description,icon,srcDownload,srcBrowser;title=err.title||AJS.I18n.getText("cp.error.default.header"),description=err.description||err.toString(),icon=err.icon||!1,srcBrowser=err.browser?file.get("src"):!1,srcDownload=err.download?file.get("srcDownload")||file.get("src"):!1,this.$el.show().html(templateStore.get("displayError")({title:title,message:description,icon:icon,srcBrowser:srcBrowser,srcDownload:srcDownload}))}});return ErrorLayer}),define("file-state",["backbone"],function(Backbone){var FileState=Backbone.Model.extend({defaults:{currentFileIndex:-1,isNewFileUploaded:!1},setCollection:function(collection){this.collection=collection},setNext:function(){var currentFileIndex=this.get("currentFileIndex");currentFileIndex<this.collection.length-1?this.set({currentFileIndex:this.get("currentFileIndex")+1}):this.set({currentFileIndex:0})},setPrev:function(){var currentFileIndex=this.get("currentFileIndex");currentFileIndex>0?this.set({currentFileIndex:this.get("currentFileIndex")-1}):this.set({currentFileIndex:this.collection.length-1})},setNoCurrent:function(){this.set({currentFileIndex:-1})},setCurrentFileIndex:function(index){return index>-1&&index<this.collection.length?this.set({currentFileIndex:index}):void 0},setCurrentWithCID:function(cid){return this.setCurrentFileIndex(this.collection.getIndexWithCID(cid))},getCurrent:function(){var current=this.collection.at(this.get("currentFileIndex"));return current||null},selectWhere:function(selector){if(selector){var selected=this.collection.findWhere(selector);selected&&this.setCurrentWithCID(selected.cid)}else this.collection.length>=1&&this.setCurrentFileIndex(0)},replaceCurrent:function(file){var idx=this.get("currentFileIndex");this.collection.remove(this.collection.at(idx)),this.collection.add(file,{at:idx})},setCurrentWithQuery:function(query){var file=this.collection.findWhere(query);file?this.setCurrentWithCID(file.cid):this.setNoCurrent()}});return FileState}),define("file-types",[],function(){var browserSupportedImageTypes=["image/gif","image/jpeg","image/png","image/svg+xml","image/web","image/bmp"],browserSupportedMultimediaTypes=["video/mp4","video/m4v","video/youtube","audio/mp3","audio/mpeg"],toLowerType=function(type){return type&&type.toLowerCase()||""},fileTypes={isPDF:function(type){var lowerType=toLowerType(type);return"application/pdf"===lowerType},isText:function(type){var lowerType=toLowerType(type);return"text/plain"===lowerType},isCode:function(type){var lowerType=toLowerType(type);return"text/java"===lowerType||"text/css"===lowerType||"text/html"===lowerType||"text/javascript"===lowerType||"text/xml"===lowerType},isMultimedia:function(type){var lowerType=toLowerType(type);return/^video\/.*/i.test(type)||/^audio\/.*/i.test(type)||"application/x-shockwave-flash"===lowerType||"application/vnd.rn-realmedia"===lowerType||"application/x-oleobject"===lowerType},isArchive:function(type){var lowerType=toLowerType(type);return"application/zip"===lowerType||"application/java-archive"===lowerType},isImage:function(type){return/^image\/.*/i.test(type)},isVideo:function(type){var lowerType=toLowerType(type);return/^video\/.*/i.test(type)||"video"===lowerType},isAudio:function(type){var lowerType=toLowerType(type);return/^audio\/.*/i.test(type)||"audio"===lowerType},isYoutube:function(type){var lowerType=toLowerType(type);return"video/youtube"===lowerType},isImageBrowserSupported:function(type){return-1!==browserSupportedImageTypes.indexOf(type.toLowerCase())},isMultimediaBrowserSupported:function(type){return-1!==browserSupportedMultimediaTypes.indexOf(type.toLowerCase())},isWordProcessing:function(type){var lowerType=toLowerType(type);return"application/msword"===lowerType||/^application\/vnd.ms-word.*/i.test(type)||/^application\/vnd.openxmlformats-officedocument.wordprocessingml.*/i.test(type)},isSpreadsheet:function(type){var lowerType=toLowerType(type);return"application/msexcel"===lowerType||/^application\/vnd.ms-excel.*/i.test(type)||/^application\/vnd.openxmlformats-officedocument.spreadsheet.*/i.test(type)},isPresentation:function(type){var lowerType=toLowerType(type);return"application/mspowerpoint"===lowerType||/^application\/vnd.ms-powerpoint.*/i.test(type)||/^application\/vnd.openxmlformats-officedocument.presentationml.*/i.test(type)},is3D:function(type){var lowerType=toLowerType(type);return"application/x-sea"===lowerType},matchAll:function(){return!0}};return fileTypes}),define("file-viewer",["jquery","underscore","backbone","assert","constants-dictionary","MainView","file-state","files","file","soy-template-backend","asset-module-backend","template-store-singleton","module-store-singleton","viewer-registry","file-types","defaultConfig","storage","image-view-provider","pdf-view-provider","video-view-provider","3d-view-provider","unknown-file-type-view-provider","Analytics","djb2"],function($,_,Backbone,assert,ConstantsDictionary,MainView,FileState,Files,File,soyTemplateBackend,assetModuleBackend,templateStore,moduleStore,ViewerRegistry,fileTypes,defaultConfig,Storage,imageViewProvider,pdfViewProvider,videoViewProvider,threeDViewProvider,unknownFileTypeViewProvider,Analytics,djb2){var FileViewer=function(config){config=_.defaults(config||{},defaultConfig),config.appendTo=config.appendTo||$("body"),FileViewer._instanceCount+=1,config.instanceId=FileViewer._instanceCount,templateStore.useBackend(config.templateBackend||soyTemplateBackend(this)),moduleStore.useBackend(config.moduleBackend||assetModuleBackend(this)),this._config=config,this._properties=new Backbone.Model,this._fileState=new FileState,this._viewerRegistry=new ViewerRegistry,this._analytics=new Analytics(config.analyticsBackend,this,djb2),-1!==config.viewers.indexOf("image")&&this._viewerRegistry.register(fileTypes.isImageBrowserSupported,imageViewProvider,0),-1!==config.viewers.indexOf("document")&&this._viewerRegistry.register(fileTypes.isPDF,pdfViewProvider,0),-1!==config.viewers.indexOf("video")&&this._viewerRegistry.register(fileTypes.isMultimediaBrowserSupported,videoViewProvider,0),-1!==config.viewers.indexOf("3d")&&this._viewerRegistry.register(fileTypes.is3D,threeDViewProvider,0),this._viewerRegistry.register(fileTypes.matchAll,unknownFileTypeViewProvider,100),this._files=new Files(config.files||[],{service:config.commentService}),this._fileState.setCollection(this._files),this._view=new MainView({model:new Backbone.Model({fileViewer:this,instanceId:config.instanceId,embedded:config.embedded})}),this._isOpen=!1,this._storage=new Storage(this.getConfig().customStorage,"fileViewer."),FileViewer._plugins.list().map(function(definition){return definition.value}).forEach(function(plugin){plugin(this)},this)};return FileViewer._instanceCount=0,FileViewer._modules=_modules,FileViewer._plugins=new ConstantsDictionary,FileViewer.VERSION="1.4.6",FileViewer.define=define,FileViewer.require=require,FileViewer.registerPlugin=function(name,plugin){assert(this.isPlugin(plugin),"is a plugin"),this._plugins.define(name,plugin)},FileViewer.isPluginEnabled=function(name){return this._plugins.isDefined(name)},FileViewer.getPlugin=function(name){return this._plugins.lookup(name)},FileViewer.isPlugin=function(potentialPlugin){return _.isFunction(potentialPlugin)},_.extend(FileViewer.prototype,Backbone.Events),Object.defineProperty(FileViewer.prototype,"analytics",{get:function(){return this._analytics}}),FileViewer.prototype.open=function(fileQuery,analyticsSource){this._view.render().show().$el.appendTo(this._config.appendTo),this._view.delegateEvents(),this._isOpen=!0,this.trigger("fv.open"),fileQuery&&this.showFileWithQuery(fileQuery).always(this.analytics.fn("files.fileviewer-web.opened",{source:analyticsSource}))},FileViewer.prototype.close=function(){this._view._currentFile=null,this._view.undelegateEvents(),this._view.hide().$el.remove(),this._isOpen=!1,this.trigger("fv.close")},FileViewer.prototype.isOpen=function(){return this._isOpen},FileViewer.prototype.showFileWithQuery=function(query){this._fileState.setCurrentWithQuery(query);var file=this._fileState.getCurrent();return this.showFile(file)},FileViewer.prototype.showFileNext=function(){return this.isShowingLastFile()&&!this.getConfig().enableListLoop?$.when():(this._fileState.setNext(),this.showFile(this._fileState.getCurrent()))},FileViewer.prototype.showFilePrev=function(){return this.isShowingFirstFile()&&!this.getConfig().enableListLoop?$.when():(this._fileState.setPrev(),this.showFile(this._fileState.getCurrent()))},FileViewer.prototype.setFiles=function(newFiles,nextFileQuery){this._files.reset(newFiles),this._fileState.setCurrentWithQuery(nextFileQuery),this.trigger("fv.setFiles"),this.isOpen()&&this.showFile(this._fileState.getCurrent())},FileViewer.prototype.getCurrent=function(){var currentFile=this._view.getCurrentFile();return currentFile&&currentFile.toJSON()},FileViewer.prototype.getCurrentFile=function(){return this._view.getCurrentFile()},FileViewer.prototype.getFiles=function(){return this._files.toJSON()},FileViewer.prototype.isShowingFirstFile=function(){return 0===this._fileState.attributes.currentFileIndex},FileViewer.prototype.isShowingLastFile=function(){return this._fileState.collection.length===this._fileState.attributes.currentFileIndex+1},FileViewer.prototype.changeMode=function(mode){this._view.setupMode(mode),this.trigger("fv.changeMode",mode)},FileViewer.prototype.getMode=function(){return this._view.getMode()},FileViewer.prototype.isInMode=function(mode){return this._view.isInMode(mode)},FileViewer.prototype.addFileAction=function(opts){assert(opts.key,"has key"),assert(opts.text,"has text"),assert(opts.callback,"has a callback"),this._view.fileControlsView.getLayerForName("moreButton").addFileAction(opts)},FileViewer.prototype.removeFileAction=function(opts){assert(opts.key,"has key"),this._view.fileControlsView.getLayerForName("moreButton").removeFileAction(opts)},FileViewer.prototype.supports=function(contentType){var previewer=this._viewerRegistry.get(contentType);return previewer&&previewer!==unknownFileTypeViewProvider},FileViewer.prototype.set=function(key,value){this._properties.set(key,value)},FileViewer.prototype.get=function(key){return this._properties.get(key)},FileViewer.prototype.getConfig=function(){return this._config},FileViewer.prototype.getView=function(){return this._view},FileViewer.prototype.getStorage=function(){return this._storage},FileViewer.prototype.showFile=function(file){return this._showFile(file)},FileViewer.prototype.showFileWithCID=function(cid){return this._fileState.setCurrentWithCID(cid),this.showFile(this._fileState.getCurrent())},FileViewer.prototype.showFileWithId=function(id,ownerId){var fileQuery={id:id};return ownerId&&(fileQuery.ownerId=ownerId),this.showFileWithQuery(fileQuery)},FileViewer.prototype.showFileWithSrc=function(src){var fileQuery={src:src};return this.showFileWithQuery(fileQuery)},FileViewer.prototype.showFileWhere=function(selector){return this._fileState.selectWhere(selector),this.showFile(this._fileState.getCurrent())},FileViewer.prototype.updateFiles=function(files,mapFn){if(mapFn&&_.isFunction(mapFn)){var newModels=_.chain(files).map(function(file){var matchedModel=this._files.find(function(collectionModel){return mapFn(collectionModel.toJSON())===mapFn(file)});return matchedModel?void matchedModel.set(file):new File(file)}.bind(this)).compact().value();this._files.add(newModels,{silent:!0}),this._files.trigger("reset",this._files)}else this._files.reset(files);return this.trigger("fv.updateFiles"),this._files.toJSON()},FileViewer.prototype._showFile=function(file){assert(this._isOpen,"FileViewer is open");var triggerEvent=function(event){return function(){this.trigger(event,file)}.bind(this)}.bind(this);return this.trigger("fv.changeFile",file),this._view.showFile(file).done(triggerEvent("fv.showFile")).fail(triggerEvent("fv.showFileError"))},FileViewer}),define("file",["backbone"],function(Backbone){var File=Backbone.Model.extend({defaults:{src:"",type:"",thumbnail:"",poster:"",title:"",downloadable:!0}});return File}),define("files",["backbone","underscore","file"],function(Backbone,_,File){var Files=Backbone.Collection.extend({model:File,getIndexWithCID:function(cid){return this.indexOf(this.get({cid:cid}))}});return Files}),define("focus-manager-factory",["assert","focus-manager-noop","focus-manager-impl"],function(assert,NoopFocusManager,FocusManager){var FocusManagerFactory=function($el){this.__element=$el};return FocusManagerFactory.prototype.create=function(embedded){var ctor=embedded?NoopFocusManager:FocusManager;return new ctor(this.__element)},FocusManagerFactory}),define("focus-manager-impl",["assert"],function(assert){var hasFocusOverride=function(element){return element&&element.hasAttribute?element.hasAttribute("data-fv-allow-focus")||hasFocusOverride(element.parentElement):!1},FocusManager=function($el){assert($el,"the first parameter to new FocusManager is a jQuery element"),this.$container=$el,this._handler=this._focusHandler.bind(this)};return FocusManager.prototype.trapFocus=function(){this._unfocusParentPage(),document.addEventListener("focus",this._handler,!0)},FocusManager.prototype.releaseFocus=function(){document.removeEventListener("focus",this._handler,!0),this._restoreFocus()},FocusManager.prototype._focusHandler=function(event){hasFocusOverride(event.target)||!this.$container||this.$container[0].contains(event.target)||(event.stopPropagation(),document.activeElement.blur(),this.$container.attr("tabindex",1),this.$container.focus())},FocusManager.prototype._unfocusParentPage=function(){this._originalActiveElement=document.activeElement,this._originalActiveElement.blur(),this.$container.attr("tabindex",1),this.$container.focus()},FocusManager.prototype._restoreFocus=function(){this._originalActiveElement&&this._originalActiveElement.focus()},FocusManager}),define("focus-manager-noop",[],function(){var noop=function(){},NoopFocusManager=function($el){};return NoopFocusManager.prototype.trapFocus=noop,NoopFocusManager.prototype.releaseFocus=noop,NoopFocusManager}),define("icon-utils",["file-types"],function(fileTypes){var iconUtils={getCssClass:function(type){var iconClass="cp-unknown-file-type-icon";return fileTypes.isImage(type)?iconClass="cp-image-icon":fileTypes.isPDF(type)?iconClass="cp-pdf-icon":fileTypes.isWordProcessing(type)?iconClass="cp-document-icon":fileTypes.isSpreadsheet(type)?iconClass="cp-spreadsheet-icon":fileTypes.isPresentation(type)?iconClass="cp-presentation-icon":fileTypes.isText(type)?iconClass="cp-text-icon":fileTypes.isCode(type)?iconClass="cp-code-icon":fileTypes.isMultimedia(type)?iconClass="cp-multimedia-icon":fileTypes.isArchive(type)&&(iconClass="cp-archive-icon"),iconClass}};return iconUtils}),define("image-view-provider",["jquery","file"],function($,File){var imageViewProvider=function(){return $.Deferred().resolve(require("image-view"))};return imageViewProvider}),define("instance-manager",["jquery"],function($){var InstanceManager=function(createFn,destroyFn){this._createFn=createFn,this._destroyFn=destroyFn,this._instance=null,this._destroyDeferred=null};return InstanceManager.prototype.create=function(){var args=arguments,d=new $.Deferred,destroyPromise=this._destroyDeferred&&this._destroyDeferred.promise()||$.when();return destroyPromise.then(function(){this._destroyDeferred=new $.Deferred,this._instance=this._createFn.apply(this._createFn,args),d.resolve(this._instance)}.bind(this)),d.promise()},InstanceManager.prototype.destroy=function(){this._destroyDeferred&&(this._destroyFn(this._instance),this._destroyDeferred.resolve())},InstanceManager}),define("keyboard",[],function(){var keys={F:70,G:71,P:80,RETURN:13,ESCAPE:27,ARROW_LEFT:37,ARROW_UP:38,ARROW_RIGHT:39,ARROW_DOWN:40,PLUS:187,MINUS:189,PLUS_NUMPAD:107,MINUS_NUMPAD:109,PLUS_FF:61,MINUS_FF:173,SPACE:32,ENTER:13,TAB:9},createConditionalKeyHandler=function(fn){return function(event){var targetTagName=event.target.tagName&&event.target.tagName.toUpperCase();return"INPUT"!==targetTagName&&"TEXTAREA"!==targetTagName?fn.call(this,event):void(event.which===keys.ESCAPE&&event.target.blur())}};return{keys:keys,createConditionalKeyHandler:createConditionalKeyHandler}}),define("layer-container-view",["underscore","backbone","assert","constants-dictionary"],function(_,Backbone,assert,ConstantsDictionary){var invoke=function(fn){return fn()},pick=function(property,obj){return obj[property]},pickBoundFn=function(property,obj){return _.isFunction(obj[property])&&obj[property].bind(obj)},FileContentLayerView=Backbone.View.extend({initialize:function(options){this._layerViewsByName=new ConstantsDictionary,this._layerViewRegistrations=[],this._layers=null,this._fileViewer=options.fileViewer},hasLayerView:function(name){return this._layerViewsByName.isDefined(name)},addLayerView:function(name,LayerView,options){assert(!this.hasLayerView(name),"name is unique"),options=_.extend({predicate:function(){return!0},weight:0},options),this._layerViewsByName.define(name,LayerView),this._layerViewRegistrations.push({LayerView:LayerView,name:name,predicate:options.predicate,weight:options.weight})},areLayersInitialized:function(){return null!==this._layers},countInitializedLayers:function(){return(this._layers||[]).length},initializeLayers:function(){this.initializeLayerSubset(_.map(this._layerViewRegistrations,function(item){return item.name}))},initializeLayerSubset:function(names){assert(!this.areLayersInitialized(),"layers are uninitialized"),this._layers=this._layerViewRegistrations.filter(function(registration){var isInSubset=-1!==names.indexOf(registration.name);return isInSubset&&registration.predicate(this._fileViewer)},this).map(function(registration){var view=new registration.LayerView({contentLayerView:this,fileViewer:this._fileViewer});return{view:view,name:registration.name,weight:registration.weight}},this),this._layers=_.sortBy(this._layers,function(layer){return-1*layer.weight}),this.trigger("initializeLayers"),this.render()},teardownLayers:function(){this.areLayersInitialized()&&(this._layers.map(_.partial(pick,"view")).map(_.partial(pickBoundFn,"teardown")).filter(_.isFunction).forEach(invoke),this._layers.map(_.partial(pick,"view")).map(_.partial(pickBoundFn,"remove")).filter(_.isFunction).forEach(invoke),this._layers=null),this.trigger("teardownLayers"),this.render()},reinitializeLayers:function(){this.teardownLayers(),this.initializeLayers()},isLayerInitialized:function(name){return this.areLayersInitialized()?!!_.find(this._layers,function(layer){return layer.name===name}):!1},getLayerForName:function(name){assert(this.areLayersInitialized(),"layers are initialized"),assert(this.hasLayerView(name),"layer is defined");var layer=_.find(this._layers,function(layer){return layer.name===name});return assert(layer,"layer is initialized"),layer.view},render:function(){return this.$el.empty(),this.areLayersInitialized()&&(this._layers.map(_.partial(pick,"view")).map(_.partial(pickBoundFn,"render")).forEach(invoke),this._layers.map(_.partial(pick,"view")).map(_.partial(pick,"$el")).forEach(function($layer){this.$el.append($layer)},this)),this.trigger("renderLayers"),this}});return FileContentLayerView}),define("MainView",["ajs","backbone","underscore","jquery","focus-manager-factory","files","file","TitleView","DownloadButton","CloseButton","MoreButton","ViewerLayer","panel-container-view","layer-container-view","ErrorLayer","WaitingLayer","PasswordLayer","ArrowLayer","ToolbarLayer","SpinnerLayer","template-store-singleton","keyboard","baseMode","presentationMode","Commands"],function(AJS,Backbone,_,$,FocusManagerFactory,Files,File,TitleView,DownloadButton,CloseButton,MoreButton,ViewerLayer,PanelContainerView,LayerContainerView,ErrorLayer,WaitingLayer,PasswordLayer,ArrowLayer,ToolbarLayer,SpinnerLayer,templateStore,keyboard,baseMode,presentationMode,Commands){var rejectWithError=function(msg){return(new $.Deferred).reject(new Error(msg)).promise()},MainView=Backbone.View.extend({attributes:function(){return{id:"cp-container-"+this.model.get("instanceId"),"data-embedded":this.model.get("embedded"),role:"dialog","aria-labelledby":"cp-title-container"}},initialize:function(params){var options=_.extend({},params);this._fileViewer=options.model.get("fileViewer"),this._currentFile=null,this._viewState=null,this._focusManager=new FocusManagerFactory(this.$el).create(this.model.get("embedded")),this.fileTitleView=new PanelContainerView({fileViewer:this._fileViewer,id:"cp-title-container",className:"aui-item"}),this.fileControlsView=new LayerContainerView({fileViewer:this._fileViewer,id:"cp-file-controls",className:"aui-item"}),this.fileMetaView=new LayerContainerView({
fileViewer:this._fileViewer,id:"cp-meta"}),this.fileSinkView=new PanelContainerView({id:"cp-sink",collection:this._fileViewer._fileState.collection,fileViewer:this._fileViewer}),this.fileSidebarView=new PanelContainerView({id:"cp-sidebar",fileViewer:this._fileViewer,collection:this._fileViewer._fileState.collection}),this.fileContentView=new LayerContainerView({id:"cp-file-body",fileViewer:this._fileViewer}),this.fileTitleView.addPanelView("title",TitleView),this.fileControlsView.addLayerView("downloadButton",DownloadButton,{weight:10,predicate:DownloadButton.isDownloadable}),this.fileControlsView.addLayerView("moreButton",MoreButton),this.fileControlsView.addLayerView("closeButton",CloseButton),this.fileContentView.addLayerView("content",ViewerLayer),this.fileContentView.addLayerView("error",ErrorLayer),this.fileContentView.addLayerView("password",PasswordLayer),this.fileContentView.addLayerView("toolbar",ToolbarLayer),this.fileContentView.addLayerView("waiting",WaitingLayer),this.fileContentView.addLayerView("spinner",SpinnerLayer),this.fileContentView.addLayerView("arrows",ArrowLayer),this.listenTo(this.fileSidebarView,"togglePanel",this._updateContentWidth),this.listenTo(this.fileSinkView,"togglePanel",this._updateContentHeight),this._navigationKeyLockCount=0,this._showFileChain=$.when(),this._mode="BASE",this._modes={BASE:baseMode,PRESENTATION:presentationMode},this._fixTooltipCleanup()},show:function(){return this.$el.show(),$(this._fileViewer._config.appendTo).addClass("no-scroll"),this.$el.on("mouseup mousedown","a",function(e){this.blur()}),this.$el.on("mouseup mousedown","button",function(e){this.blur()}),$(document).on("keydown.disableDefaultKeys",this._disableKeyboardShortcuts.bind(this)),$(document).on("keydown.navKeys",keyboard.createConditionalKeyHandler(this._handleNavigationKeys.bind(this))),this},hide:function(){return this.$el.hide(),$(this._fileViewer._config.appendTo).removeClass("no-scroll"),$(document).off("keydown.disableDefaultKeys"),$(document).off("keydown.navKeys"),$(document).off("keydown.modeKeys"),this._deactivateModeHook(),this._modes[this._mode].teardown(this),this._teardownAll(),this},render:function(){return this.$el.empty().append(templateStore.get("fileView")()),this.$header=this.$("#cp-header"),this.$body=this.$("#cp-body"),this.$footer=this.$("#cp-footer"),this.$title=this.fileTitleView.render().$el.appendTo(this.$header),this.$controls=this.fileControlsView.render().$el.appendTo(this.$header),this.$content=this.fileContentView.render().$el.appendTo(this.$body),this.$sidebar=this.fileSidebarView.render().$el.appendTo(this.$body),this.$meta=this.fileMetaView.render().$el.appendTo(this.$footer),this.$sink=this.fileSinkView.render().$el.appendTo(this.$footer),this.$el.on("click",'a[href="#"]',function(e){e.preventDefault()}),this._focusManager.trapFocus(),this},showFile:function(file){var needsToRerenderContent=!this.fileContentView.isLayerInitialized("content")||MainView._needsToRerenderContent(this._currentFile,file);if(MainView._filesWillRenderTheSame(this._currentFile,file))return MainView._skipRenderingOf(file);var contentView,toolbarView,spinnerView,waitingView,errorView,lookupViewerCommand=new Commands.LookupViewer(file,this._fileViewer._viewerRegistry);this.trigger("cancelShow");var fileViewed=new $.Deferred;return this._showFileChain.pipe(function(){var fileHandled=new $.Deferred,p=$.when().pipe(function(){this._currentFile=file,this._viewState=null;var validationResult;return file?(needsToRerenderContent?(this.trigger("fv.fileChange",file),this._reinitializeAllSubviews()):this._reinitializeNonContentSubviews(),contentView=this.fileContentView.getLayerForName("content"),toolbarView=this.fileContentView.getLayerForName("toolbar"),spinnerView=this.fileContentView.getLayerForName("spinner"),waitingView=this.fileContentView.getLayerForName("waiting")):(this._viewState="fileNotFound",this._reinitializeCoreSubviews(),validationResult=rejectWithError(AJS.I18n.getText("cp.error.file.not.found"))),errorView=this.fileContentView.getLayerForName("error"),this._deactivateModeHook(),this._activateModeHook(),this&&this._fileViewer&&this._fileViewer.lastFocusId&&$("#"+this._fileViewer.lastFocusId).focus(),validationResult}.bind(this));return needsToRerenderContent&&(p=p.pipe(function(){var isPreviewGenerated=this._fileViewer.getConfig().isPreviewGenerated,generatePreview=this._fileViewer.getConfig().generatePreview;return spinnerView.startSpin(),this._fileViewer.supports(file.get("type"))?$.when(file.get("src"),file.get("type")):isPreviewGenerated&&generatePreview?isPreviewGenerated(file).pipe(function(isGenerated,source,type,overwrites){return isGenerated?$.when(source,type,overwrites):(spinnerView.stopSpin(),waitingView.showMessage(file,AJS.I18n.getText("cp.file.converting.message.header"),AJS.I18n.getText("cp.file.converting.message.text")),generatePreview(file).always(function(){waitingView.clearMessage(),spinnerView.startSpin()}))}):$.when(file.get("src"),file.get("type"))}.bind(this)).pipe(lookupViewerCommand.execute.bind(lookupViewerCommand)).pipe(function(Viewer,previewSrc,convertedFile){var readyDeferred=new $.Deferred,view=new Viewer({previewSrc:previewSrc,model:new File(convertedFile.toJSON()),fileViewer:this._fileViewer});return view.once("viewerReady",function(){this._viewState="success",toolbarView.setViewer(view),this.setupMode(this._mode),readyDeferred.resolve(file)}.bind(this)),view.once("viewerFail",function(err){this._viewState="viewerError",readyDeferred.reject(err),this.setupMode(this._mode)}.bind(this)),contentView.attachViewer(view),view.render(),readyDeferred.promise()}.bind(this)).always(function(){spinnerView&&spinnerView.stopSpin(),waitingView&&waitingView.clearMessage()}.bind(this)).fail(function(err){fileViewed.reject(err),"cancelled"!==err&&errorView.showErrorMessage(err,file)}.bind(this))),p.done(function(){fileViewed.resolve(file)}).always(function(){fileHandled.resolve()}.bind(this)),fileHandled.promise()}.bind(this)),fileViewed.promise()},getCurrentFile:function(){return this._currentFile},getViewState:function(){return this._viewState||"loading"},_reinitializeAllSubviews:function(){this.fileTitleView.isAnyPanelInitialized()||this.fileTitleView.initializePanel(),this.fileTitleView.reinitializePanel(),this.fileControlsView.reinitializeLayers(),this.fileContentView.reinitializeLayers(),this.fileSidebarView.reinitializePanel(),this.fileMetaView.reinitializeLayers(),this.fileSinkView.reinitializePanel(),this._updateMetaBannerHeight()},_reinitializeNonContentSubviews:function(){this.fileTitleView.isAnyPanelInitialized()||this.fileTitleView.initializePanel(),this.fileTitleView.reinitializePanel(),this.fileControlsView.reinitializeLayers(),this.fileSidebarView.reinitializePanel(),this.fileMetaView.reinitializeLayers(),this.fileSinkView.reinitializePanel(),this._updateMetaBannerHeight()},_reinitializeCoreSubviews:function(){this._teardownAll(),this.fileControlsView.initializeLayerSubset(["closeButton"]),this.fileContentView.initializeLayerSubset(["arrows","error"])},_teardownAll:function(){this.fileTitleView.teardownPanel(),this.fileSidebarView.teardownPanel(),this.fileSinkView.teardownPanel(),this.fileMetaView.teardownLayers(),this.fileControlsView.teardownLayers(),this.fileContentView.teardownLayers(),this._focusManager.releaseFocus()},_handleNavigationKeys:function(e){var numFiles=this._fileViewer._files.length,usedModifierKey=e.altKey||e.ctrlKey||e.metaKey||e.shiftKey;e.which!==keyboard.keys.ESCAPE||this.isNavigationLocked()?!usedModifierKey&&!this.isNavigationLocked()&&numFiles>1&&e.which===keyboard.keys.ARROW_RIGHT?(e.preventDefault(),this._fileViewer.showFileNext().always(this._fileViewer.analytics.fn("files.fileviewer-web.next",{actionType:"hotkey",mode:this._fileViewer.getMode()}))):!usedModifierKey&&!this.isNavigationLocked()&&numFiles>1&&e.which===keyboard.keys.ARROW_LEFT&&(e.preventDefault(),this._fileViewer.showFilePrev().always(this._fileViewer.analytics.fn("files.fileviewer-web.prev",{actionType:"hotkey",mode:this._fileViewer.getMode()}))):(e.preventDefault(),this._fileViewer.analytics.send("files.fileviewer-web.closed",{actionType:"hotkey"}),this._fileViewer.close())},lockNavigationKeys:function(){this._navigationKeyLockCount+=1},unlockNavigationKeys:function(){this._navigationKeyLockCount>=1&&(this._navigationKeyLockCount-=1)},isNavigationLocked:function(){return 0!==this._navigationKeyLockCount},_disableKeyboardShortcuts:function(e){if(e.ctrlKey||e.metaKey)switch(e.which){case keyboard.keys.F:case keyboard.keys.G:e.preventDefault();break;case keyboard.keys.P:e.preventDefault()}},_onClickToBackground:function(e){var mode=this._fileViewer._view._modes[this._fileViewer._view._mode];if(!mode.disableClickBackgroundCloses){var backgroundLayers=["cp-error-layer","cp-waiting-layer","cp-password-layer"];backgroundLayers.indexOf(e.target.className)>=0&&(this._fileViewer.analytics.send("files.fileviewer-web.closed",{actionType:"element"}),this._fileViewer.close())}},_updateContentWidth:function(panelId,isExpanded){this.$content&&this.$content.toggleClass("narrow",isExpanded),this._resizeActiveViewer()},_updateContentHeight:function(panelId,isExpanded){this.$content&&this.$content.toggleClass("short",isExpanded),this.$sidebar&&this.$sidebar.toggleClass("short",isExpanded),this._resizeActiveViewer()},_updateMetaBannerHeight:function(){var showsMetaView=this.fileMetaView.countInitializedLayers()>0;this.fileContentView.$el.toggleClass("meta-banner",showsMetaView),this.fileSidebarView.$el.toggleClass("meta-banner",showsMetaView)},_resizeActiveViewer:function(){if(this.fileContentView.isLayerInitialized("content")){var contentView=this.fileContentView.getLayerForName("content"),viewer=contentView.getAttachedViewer();viewer&&viewer.handleResize()}},_fixTooltipCleanup:function(){var removeAllTooltips=function(){$(".tipsy").remove()};this._fileViewer.on("fv.changeFile",removeAllTooltips),this._fileViewer.on("fv.close",removeAllTooltips)},getMode:function(){return this._mode||""},isInMode:function(mode){return this._mode===mode},setupMode:function(mode){var toolbar=this.fileContentView.getLayerForName("toolbar"),viewer=toolbar._viewer,$arrowLayer=this.fileContentView.getLayerForName("arrows").$el,lastMode=this._mode,isModeChanged=lastMode!==mode,modeObj=this._modes[mode],lastModeObj=this._modes[lastMode];isModeChanged?(this._deactivateModeHook(),this._mode=mode,this._activateModeHook()):this._mode=mode,$(document).off("keydown.modeKeys"),lastModeObj.teardown(this,viewer,isModeChanged),modeObj.setup(this,viewer),$arrowLayer.toggle(modeObj.showsArrowLayer),toolbar.setActions(modeObj.toolbarActions),toolbar.render(),viewer&&viewer.setupMode&&viewer.setupMode(mode,isModeChanged)},_activateModeHook:function(){var mode=this._modes[this._mode];mode.activateHook&&mode.activateHook(this)},_deactivateModeHook:function(){var mode=this._modes[this._mode];mode.deactivateHook&&mode.deactivateHook(this)},updatePaginationButtons:function(){if(this.isInMode("PRESENTATION")){var toolbar=this.fileContentView.getLayerForName("toolbar");if(!toolbar._viewer)return;var $toolbarPrevPage=toolbar.$el.find(".cp-toolbar-prev-page"),$toolbarNextPage=toolbar.$el.find(".cp-toolbar-next-page");$toolbarPrevPage.toggleClass("inactive",!1),$toolbarNextPage.toggleClass("inactive",!1),toolbar._viewer.hasPreviousPage()||toolbar._viewer.hasNextPage()?toolbar._viewer.hasPreviousPage()?toolbar._viewer.hasNextPage()||$toolbarNextPage.toggleClass("inactive",!0):$toolbarPrevPage.toggleClass("inactive",!0):($toolbarPrevPage.hide(),$toolbarNextPage.hide())}}});return MainView._filesWillRenderTheSame=function(fileA,fileB){return fileA&&fileB?_.isEqual(fileA.attributes,fileB.attributes):!1},MainView._needsToRerenderContent=function(fileA,fileB){if(!fileA||!fileB)return!0;var didTypeChange=fileA.get("type")!==fileB.get("type"),didSrcChange=fileA.get("src")!==fileB.get("src"),didThumbChange=fileA.get("thumbnail")!==fileB.get("thumbnail");return didTypeChange||didSrcChange||didThumbChange},MainView._skipRenderingOf=function(file){return $.when(file)},MainView}),define("module-store-singleton",["module-store"],function(ModuleStore){return new ModuleStore}),define("module-store",["assert","jquery","underscore"],function(assert,$,_){var ModuleStore=function(){this._backend=null};return ModuleStore.validBackend=function(backend){return _.isFunction(backend)},ModuleStore.prototype.get=function(modulePath){return assert(ModuleStore.validBackend(this._backend),"backend is valid"),$.when(this._backend(modulePath))},ModuleStore.prototype.useBackend=function(backend){assert(ModuleStore.validBackend(backend),"backend is valid"),this._backend=backend},ModuleStore}),define("MoreButton",["jquery","underscore","backbone","template-store-singleton"],function($,_,Backbone,templateStore){var MoreButton=Backbone.View.extend({tagName:"span",initialize:function(options){this._fileViewer=options.fileViewer,this._fileActions=[]},render:function(){this.$el.html(templateStore.get("moreButton")());var $dropdown=this.$el.find("#cp-more-menu"),$menu=$dropdown.find("ul");$dropdown.on({"aui-dropdown2-show":function(){this.$("button").tipsy("disable")}.bind(this),"aui-dropdown2-hide":function(){this.$("button").tipsy("enable")}.bind(this)});var currentFile=this._fileViewer._fileState.getCurrent();return this.$("button").tooltip({gravity:"n"}),this._fileActions.length?(this._fileActions.forEach(function(item){var $item=$(templateStore.get("moreMenuItem")({text:item.text}));$item.click(function(e){e.preventDefault(),item.callback(currentFile)}),$menu.append($item)}),this._show()):this._hide(),this},addFileAction:function(opts){var match=_.findWhere(this._fileActions,{key:opts.key});match?_.extend(match,{key:opts.key,text:opts.text,callback:opts.callback}):this._fileActions.push({key:opts.key,text:opts.text,callback:opts.callback}),this.render()},removeFileAction:function(action){var index=_.indexOf(this._fileActions,action);this._fileActions.splice(index,1),this.render()},_show:function(){this.$el.css("display","inline")},_hide:function(){this.$el.css("display","none")}});return MoreButton}),define("panel-container-view",["backbone","assert","constants-dictionary"],function(Backbone,assert,ConstantsDictionary){var PanelContainerView=Backbone.View.extend({className:"panel-view",initialize:function(options){this._panelViewsByName=new ConstantsDictionary,this._currentPanel=null,this._currentPanelName=null,this._lastAddedPanelName=null,this._fileViewer=options.fileViewer},hasPanelView:function(name){return this._panelViewsByName.isDefined(name)},addPanelView:function(name,PanelView){this._panelViewsByName.define(name,PanelView),this._lastAddedPanelName=name},isAnyPanelInitialized:function(){return this.$el.is(".expanded")},isPanelInitialized:function(name){return this._currentPanelName===name},initializePanel:function(name){name=name||this._lastAddedPanelName,assert(this.isAnyPanelInitialized()===!1,"no panel is initialized"),assert(this.hasPanelView(name)===!0,"panel exists");var PanelView=this._panelViewsByName.lookup(name);this._currentPanelName=name,this._currentPanel=new PanelView({collection:this.collection,fileViewer:this._fileViewer,panelView:this}),this.$el.toggleClass("expanded",!0),this.trigger("initializePanel",this._currentPanelName),this.trigger("togglePanel",this._currentPanelName,!0),this.render()},teardownPanel:function(){this._currentPanel&&(this._currentPanel.teardown&&this._currentPanel.teardown(),this._currentPanel.remove()),this.$el.toggleClass("expanded",!1),this.trigger("togglePanel",this._currentPanelName,!1),this.trigger("teardownPanel",this._currentPanelName),this._currentPanelName=null,this._currentPanel=null,this.render()},reinitializePanel:function(){if(this.isAnyPanelInitialized()){var previousPanel=this.getInitializedPanelName();this.teardownPanel(),this.initializePanel(previousPanel)}},getInitializedPanelName:function(){return assert(this.isAnyPanelInitialized(),"a panel is initialized"),this._currentPanelName},getInitializedPanel:function(){return this._currentPanel},render:function(){return this.$el.empty(),this.isAnyPanelInitialized()&&(this._currentPanel.render(),this._currentPanel.$el.appendTo(this.$el)),this.trigger("renderPanel",this._currentPanelName),this}});return PanelContainerView}),define("PasswordLayer",["ajs","backbone","jquery","keyboard","template-store-singleton"],function(AJS,Backbone,$,keyboard,templateStore){var pdfjsPasswordResponses={NEED_PASSWORD:1,INCORRECT_PASSWORD:2},fullscreenEvents=["fullscreenchange","webkitfullscreenchange","mozfullscreenchange","MSFullscreenChange"].join(" "),isFullscreen=function(){return document.fullscreenElement||document.mozFullScreen||document.webkitIsFullScreen||document.msFullscreenElement},PasswordLayer=Backbone.View.extend({className:"cp-password-layer",events:{"keydown .cp-password-input":"_handleKeyDown","click .cp-password-button":"_handleClick","focus .cp-password-input":"_lockNavigation","blur .cp-password-input":"_unlockNavigation"},initialize:function(options){this._fileViewer=options.fileViewer,this.$el.hide()},teardown:function(){$(document).off(fullscreenEvents,this.updatePasswordLayer.bind(this))},showPasswordInput:function(reason,updatePassword){$(document).on(fullscreenEvents,this.updatePasswordLayer.bind(this)),this.updatePassword=updatePassword,this._fileViewer._view.fileContentView.getLayerForName("spinner").stopSpin(),this.$el.show().html(templateStore.get("passwordLayer")({prompt:this._getPromptTitle(reason)})),this.updatePasswordLayer(),this._showToolbar()},hidePasswordInput:function(){$(document).off(fullscreenEvents,this.updatePasswordLayer.bind(this)),this.$el.empty(),this.$el.hide()},updatePasswordLayer:function(){isFullscreen()?(this.$el.find(".cp-password-base").hide(),this.$el.find(".cp-password-fullscreen").show()):(this.$el.find(".cp-password-fullscreen").hide(),this.$el.find(".cp-password-base").show())},_getPromptTitle:function(reason){var title=AJS.I18n.getText("cp.password.needed");return reason===pdfjsPasswordResponses.INCORRECT_PASSWORD&&(title=AJS.I18n.getText("cp.password.incorrect")),title},_showToolbar:function(){var view=this._fileViewer._view,toolbar=view.fileContentView.getLayerForName("toolbar"),mode=view._modes[view._mode];toolbar.setActions(mode.toolbarActions),toolbar.render()},_updatePassword:function(){var password=this.$el.find(".cp-password-input").val();password&&password.length>0&&(this.hidePasswordInput(),this.updatePassword(password))},_lockNavigation:function(){this._fileViewer._view._navigationKeyLockCount++},_unlockNavigation:function(){this._fileViewer._view._navigationKeyLockCount--},_handleClick:function(ev){ev.preventDefault(),this._updatePassword()},_handleKeyDown:function(ev){return ev.which===keyboard.keys.RETURN?(ev.preventDefault(),this._updatePassword()):ev.which===keyboard.keys.ESCAPE?(ev.preventDefault(),this._fileViewer.close()):void 0}});return PasswordLayer}),define("pdf-view-provider",["jquery","file","module-store-singleton"],function($,File,moduleStore){var asyncViewerResource=null,asyncConfigResource=null,pdfViewProvider=function(){asyncViewerResource||(asyncViewerResource=moduleStore.get("pdf-viewer")),asyncConfigResource||(asyncConfigResource=moduleStore.get("pdf-config"));var viewerInstance=$.Deferred();return $.when(asyncViewerResource,asyncConfigResource).done(function(viewer,config){var PDFViewer=require("pdf-view"),PDFJS=window.PDFJS;PDFJS.workerSrc=config.workerSrc,PDFJS.cMapUrl=config.cMapUrl,viewerInstance.resolve(PDFViewer)}),viewerInstance.promise()};return pdfViewProvider}),define("presentationMode",["jquery","keyboard"],function($,keyboard){var AJS=window.AJS,requestFullscreen=function(){var fullscreenContainer=$("#cp-file-body")[0];fullscreenContainer.requestFullscreen?fullscreenContainer.requestFullscreen():fullscreenContainer.mozRequestFullScreen?fullscreenContainer.mozRequestFullScreen():fullscreenContainer.webkitRequestFullScreen?fullscreenContainer.webkitRequestFullScreen():fullscreenContainer.msRequestFullscreen&&fullscreenContainer.msRequestFullscreen()},cancelFullscreen=function(){document.cancelFullscreen?document.cancelFullscreen():document.mozCancelFullScreen?document.mozCancelFullScreen():document.webkitCancelFullScreen?document.webkitCancelFullScreen():document.msExitFullscreen&&document.msExitFullscreen()},isFullscreen=function(){return document.fullscreenElement||document.mozFullScreen||document.webkitIsFullScreen||document.msFullscreenElement},onFullscreenChange=function(e){isFullscreen()||this.isInMode("BASE")||(this._fileViewer.analytics.send("files.fileviewer-web.presentation.exit",{actionType:"hotkey"}),this._fileViewer.changeMode("BASE"))},presentationMode={activateHook:function(mainView){$(document).on("fullscreenchange webkitfullscreenchange mozfullscreenchange MSFullscreenChange",onFullscreenChange.bind(mainView));var $arrowLayer=mainView.fileContentView.getLayerForName("arrows").$el;$arrowLayer.toggle(this.showsArrowLayer)},deactivateHook:function(mainView){$(document).off("fullscreenchange webkitfullscreenchange mozfullscreenchange MSFullscreenChange",onFullscreenChange.bind(mainView))},setup:function(mainView,viewer){this._originalScrollTop=$("body").scrollTop(),$("#cp-file-body").addClass("presentation"),$(document).on("keydown.modeKeys",this._handleKeys.bind(mainView)),isFullscreen()||requestFullscreen()},teardown:function(mainView,viewer,isModeChanged){$("#cp-file-body").removeClass("presentation"),$(document).off("keydown.modeKeys"),isModeChanged&&isFullscreen()&&cancelFullscreen(),$("body").scrollTop(this._originalScrollTop)},disableClickBackgroundCloses:!0,showsArrowLayer:!1,_handleKeys:function(e){e.preventDefault();var contentView,viewer;if(this.fileContentView.isLayerInitialized("content")&&(contentView=this.fileContentView.getLayerForName("content"),viewer=contentView.getAttachedViewer()),viewer&&!e.ctrlKey&&!e.metaKey)switch(e.which){case keyboard.keys.ARROW_UP:return void(viewer.goToPreviousPage&&(this._fileViewer.analytics.send("files.fileviewer-web.presentation.pageprev",{actionType:"hotkey"}),viewer.goToPreviousPage(),this.updatePaginationButtons()));case keyboard.keys.ARROW_DOWN:return void(viewer.goToNextPage&&(this._fileViewer.analytics.send("files.fileviewer-web.presentation.pagenext",{actionType:"hotkey"}),viewer.goToNextPage(),this.updatePaginationButtons()))}},toolbarActions:[{title:AJS.I18n.getText("cp.go.to.prev.page"),className:"cp-toolbar-prev-page",predicate:function(){return this._viewer&&this._viewer.goToPreviousPage},handler:function(){this._viewer&&this._viewer.goToPreviousPage&&(this._fileViewer.analytics.send("files.fileviewer-web.presentation.pageprev",{actionType:"button"}),this._viewer.goToPreviousPage(),this._fileViewer.getView().updatePaginationButtons())}},{title:AJS.I18n.getText("cp.exit.presentation.mode"),className:"cp-toolbar-presentation-exit",handler:function(){this._fileViewer.analytics.send("files.fileviewer-web.presentation.exit",{actionType:"button"}),this._fileViewer.changeMode("BASE")}},{title:AJS.I18n.getText("cp.go.to.next.page"),className:"cp-toolbar-next-page",predicate:function(){return this._viewer&&this._viewer.goToNextPage},handler:function(){this._viewer&&this._viewer.goToNextPage&&(this._fileViewer.analytics.send("files.fileviewer-web.presentation.pagenext",{actionType:"button"}),this._viewer.goToNextPage(),this._fileViewer.getView().updatePaginationButtons())}}]};return presentationMode}),define("soy-template-backend",[],function(){var getNestedProperty=function(obj,prop){var i,levels=prop.split(".");for(i=0;i<levels.length;i++)obj=obj[levels[i]];return obj};return function(fileViewer){return function(templateUrl){return getNestedProperty(FileViewer.Templates,templateUrl)}}}),define("SpinnerLayer",["backbone","template-store-singleton"],function(Backbone,templateStore){var SPINNER_SIZE="large",SPINNER_STYLE={color:"#fff",zIndex:"auto"},SpinnerLayer=Backbone.View.extend({className:"cp-spinner-layer",initialize:function(){this._updateElements()},render:function(){return this.$el.html(templateStore.get("fileBodySpinner")()),this._updateElements(),this},startSpin:function(){this.$spinner.spin(SPINNER_SIZE,SPINNER_STYLE)},stopSpin:function(){this.$spinner.spin(!1)},_updateElements:function(){this.$spinner=this.$el.find(".cp-spinner")}});return SpinnerLayer}),define("storage",["assert"],function(assert){var Storage=function(customStorage,namespace){this._namespace=namespace||"",this._storage=this._getStorage(customStorage)};Storage.prototype.getItem=function(key){var storageValue;return key=this._namespace+key.toString(),storageValue=new StorageValue,storageValue.fromJSON(this._storage.getItem(key)),storageValue.isExpired()?void this._storage.removeItem(key):storageValue.value},Storage.prototype.setItem=function(key,value,expiry){key=this._namespace+key.toString(),this._storage.setItem(key,new StorageValue(value,expiry).toJSON())},Storage.prototype.removeItem=function(key){key=this._namespace+key.toString(),this._storage.removeItem(key)},Storage.prototype._hasLocalStorage=function(){var test=this._namespace+"hasLocalStorage";try{return localStorage.setItem(test,test),localStorage.removeItem(test),!0}catch(e){return!1}},Storage.prototype._getStorage=function(customStorage){return customStorage?(assert("function"==typeof customStorage.setItem,"Storage custom.setItem is a function"),assert("function"==typeof customStorage.getItem,"Storage custom.getItem is a function"),assert("function"==typeof customStorage.removeItem,"Storage custom.removeItem is a function"),customStorage):this._hasLocalStorage()?Storage.localStorage:Storage.noStorage},Storage.noStorage={setItem:function(){},getItem:function(){},removeItem:function(){}},Storage.localStorage={setItem:function(key,value){window.localStorage.setItem(key,value)},getItem:function(key){return window.localStorage.getItem(key)},removeItem:function(key){window.localStorage.removeItem(key)}};var StorageValue=Storage.StorageValue=function(value,expiry){this.value=value,this._setExpiry(expiry)};return StorageValue.prototype._setExpiry=function(expiry){parseInt(expiry)?this.expiry=Date.now()+expiry:this.expiry=null},StorageValue.prototype.isExpired=function(){return this.expiry&&Date.now()>this.expiry},StorageValue.prototype.fromJSON=function(stringifiedJson){var json;stringifiedJson=stringifiedJson||"{}",json=JSON.parse(stringifiedJson),this.value=json.value,this.expiry=json.expiry},StorageValue.prototype.toJSON=function(){return JSON.stringify({value:this.value,expiry:this.expiry||void 0})},Storage}),define("template-store-singleton",["template-store"],function(TemplateStore){return new TemplateStore}),define("template-store",["assert","underscore"],function(assert,_){var TemplateStore=function(){this._backend=null};return TemplateStore.validBackend=function(backend){return _.isFunction(backend)},TemplateStore.prototype.get=function(templateUrl){return assert(TemplateStore.validBackend(this._backend),"backend is valid"),this._backend(templateUrl)},TemplateStore.prototype.useBackend=function(backend){assert(TemplateStore.validBackend(backend),"backend is valid"),this._backend=backend},TemplateStore}),define("TitleView",["backbone","icon-utils","template-store-singleton"],function(Backbone,iconUtils,templateStore){var TitleView=Backbone.View.extend({initialize:function(options){this._fileViewer=options.fileViewer},render:function(){var model=this._fileViewer.getCurrentFile();if(model)return this.$el.html(templateStore.get("titleContainer")({title:model.get("title"),iconClass:iconUtils.getCssClass(model.get("type"))})),this}});return TitleView}),define("ToolbarLayer",["jquery","underscore","backbone","template-store-singleton","keyboard"],function($,_,Backbone,templateStore,keyboard){var HIDE_CONTROLS_TIMEOUT=500,THROTTLE_MOUSEMOVE=HIDE_CONTROLS_TIMEOUT-100,HIDE_ANIMATION_DURATION=400,SHOW_ANIMATION_DURATION=100,ToolbarLayer=Backbone.View.extend({className:"cp-toolbar-layer",initialize:function(options){this._fileViewer=options.fileViewer,this._viewer=null,this._toggleControlsTimeout=null,this._actions=[],$("#cp-file-body").on("mousemove.toolbarLayer",this._showControlsOnMove.bind(this)),$(document).on("keydown.tabToNavigate",this._tabToNavigate.bind(this))},teardown:function(){$(document).off("keydown.tabToNavigate"),$("#cp-file-body").off("mousemove.toolbarLayer")},render:function(){this.$el.html(templateStore.get("toolbar")({actions:this._actions})),this.$el.find("button").tooltip({gravity:"s",aria:!0}),this.$toolbar=this.$(".cp-toolbar");var listeners={};return this._actions.forEach(function(action){listeners["click ."+action.className]=action.handler,action.predicate&&!action.predicate.call(this)&&this.$toolbar.find("."+action.className).hide()},this),this.delegateEvents(listeners),this.$toolbar.css("margin-left",-this.$toolbar.width()/2),this.$toolbar.on("click","a[href='#']",function(e){e.preventDefault()}),this},setActions:function(actions){this._actions=actions,this.render()},getActions:function(){return this._actions},setViewer:function(viewer){this._viewer=viewer,this.render()},_tabToNavigate:function(event){event.which===keyboard.keys.TAB&&this._showControlsOnMove.call(this)},_showControlsOnMove:_.throttle(function(){this.$toolbar&&(this.$toolbar.fadeTo(SHOW_ANIMATION_DURATION,1),clearTimeout(this._toggleControlsTimeout),this._toggleControlsTimeout=this._setHideTimer())},THROTTLE_MOUSEMOVE),_setHideTimer:function(){return setTimeout(function(){this.$toolbar.is(":hover")||this.$toolbar.has(":focus").length||(this.$toolbar.find("button").each(this._removeTooltipForElement),this.$toolbar.fadeTo(HIDE_ANIMATION_DURATION,0))}.bind(this),HIDE_CONTROLS_TIMEOUT)},_removeTooltipForElement:function(pos,el){var tipsyId=$(el).attr("aria-describedby");tipsyId&&$("#"+tipsyId).fadeOut()}});return ToolbarLayer}),define("unknown-file-type-view-provider",["jquery","unknown-file-type-view"],function($,UnknownFileTypeView){var unknownFileTypeViewProvider=function(){return $.Deferred().resolve(UnknownFileTypeView)};return unknownFileTypeViewProvider}),define("unknown-file-type-view",["ajs","BaseViewer","template-store-singleton","icon-utils","jquery"],function(AJS,BaseViewer,templateStore,iconUtils,$){var UnknownFileTypeView=BaseViewer.extend({id:"cp-unknown-file-type-view-wrapper",events:{"click .download-button":"_handleDownloadButton"},initialize:function(){BaseViewer.prototype.initialize.apply(this,arguments)},teardown:function(){this.off(),this.remove()},render:function(){this.$el.html(templateStore.get("unknownFileTypeViewer")({iconClass:iconUtils.getCssClass(this.model.get("type")),src:this.model.get("srcDownload")||this.model.get("src")}));var fileView=this._fileViewer.getView();return fileView.fileSidebarView.isAnyPanelInitialized()&&fileView.fileSidebarView.teardownPanel(),this.trigger("viewerReady"),this},setupMode:function(mode){"BASE"===mode&&$(".cp-toolbar-layer").hide()},_handleDownloadButton:function(){this._fileViewer.trigger("fv.download"),this._triggerAnalytics()},_triggerAnalytics:function(){this._fileViewer.analytics.send("files.fileviewer-web.file.download",{actionType:"cta"})}});return UnknownFileTypeView}),define("url",[],function(){return{addQueryParamToUrl:function(url,param){param=param||{},url=url.split("?");var queryArray=url[1]&&url[1].split("&");return queryArray=queryArray||[],Object.keys(param).forEach(function(key,val){queryArray.push(key+"="+param[key])}),0===queryArray.length?url[0]:url[0]+"?"+queryArray.join("&")},parseQueryString:function(query){for(var parts=query.split("&"),params={},i=0,ii=parts.length;ii>i;++i){var param=parts[i].split("="),key=param[0].toLowerCase(),value=param.length>1?param[1]:null;params[decodeURIComponent(key)]=decodeURIComponent(value)}return params}}}),define("video-view-provider",["jquery","file"],function($,File){var videoViewProvider=function(){return $.Deferred().resolve(require("video-view"))};return videoViewProvider}),define("viewer-registry",["underscore","assert"],function(_,assert){
var createMatchFn=function(expected){return function(current){return current===expected}},ViewerRegistry=function(){this._handlers=[]};return ViewerRegistry.isValidPreviewer=function(previewer){return _.isFunction(previewer)},ViewerRegistry.isValidWeight=function(weight){return"number"==typeof weight&&!isNaN(weight)},ViewerRegistry.prototype.register=function(fileType,previewer,weight){var matchesFileType="function"==typeof fileType?fileType:createMatchFn(fileType);weight=weight||10,assert(ViewerRegistry.isValidPreviewer(previewer),"previewer is valid"),assert(ViewerRegistry.isValidWeight(weight),"weight is valid"),this._handlers.push({matchesFileType:matchesFileType,previewer:previewer,weight:weight}),this._updateWeighting()},ViewerRegistry.prototype.get=function(fileType){var handler=_.find(this._handlers,function(handler){return handler.matchesFileType(fileType)});return handler&&handler.previewer},ViewerRegistry.prototype._updateWeighting=function(){this._handlers=_.sortBy(this._handlers,function(handler){return handler.weight})},ViewerRegistry}),define("ViewerLayer",["backbone"],function(Backbone){var ViewerLayer=Backbone.View.extend({className:"cp-viewer-layer",initialize:function(options){this._viewer=null},attachViewer:function(viewer){this._viewer=viewer,this.$el.prepend(viewer.$el)},getAttachedViewer:function(){return this._viewer},teardown:function(){this._viewer&&(this._viewer.teardown&&this._viewer.teardown(),this._viewer.$el.remove())}});return ViewerLayer}),define("WaitingLayer",["backbone","template-store-singleton"],function(Backbone,templateStore){var WaitingLayer=Backbone.View.extend({className:"cp-waiting-layer",initialize:function(){this.$el.hide()},showMessage:function(file,header,message){this.$el.show().html(templateStore.get("waitingMessage")({src:file.get("srcDownload")||file.get("src"),header:header,message:message})),this.$el.find(".cp-waiting-message-spinner").spin("large",{color:"#fff",zIndex:"auto"})},clearMessage:function(){this.$el.find(".cp-waiting-message-spinner").spin(!1),this.$el.hide()}});return WaitingLayer});var FileViewer=require("file-viewer");FileViewer.Templates=window.FileViewer.Templates,"undefined"!=typeof module&&module.exports&&(module.exports=FileViewer),window.define&&window.define("FileViewer",["jquery","underscore","backbone","ajs"],function(){return FileViewer}),window.FileViewer=FileViewer}();