!function(FileViewer){"use strict";var define=FileViewer.define,require=FileViewer.require;define("video-view/button-presentation-mode",[],function(){var videojs=window.videojs,ButtonPresentationMode=videojs.Button.extend({init:function(opts){this._fileViewer=opts.fileViewer,this._player=opts.player,videojs.Button.call(this,this._player,{el:videojs.Component.prototype.createEl(null,{className:"vjs-presentation-control vjs-control",innerHTML:['<div class="vjs-control-content">','<span class="vjs-control-text">',"Presentation Mode","</span>","</div>"].join(""),role:"button",tabindex:0,"aria-live":"polite"})}),this.on("click",this.changeMode)}});return ButtonPresentationMode.asPlugin=function(fileViewer){return function(options){var player=this,button=new ButtonPresentationMode({player:player,fileViewer:fileViewer});button.options=options,player.ready(function(){player.controlBar.addChild(button)})}},ButtonPresentationMode.prototype.changeMode=function(){this._fileViewer.isInMode("PRESENTATION")?this._fileViewer.changeMode("BASE"):this._fileViewer.changeMode("PRESENTATION")},ButtonPresentationMode}),define("video-view/button-toggle-hd",["template-store-singleton","jquery"],function(templateStore,$){var videojs=window.videojs,ButtonToggleHd=videojs.Button.extend({init:function(opts){this._fileViewer=opts.fileViewer,this._player=opts.player,this._isPlayingHd=opts.isPlayingHd,videojs.Button.call(this,this._player,{el:videojs.Component.prototype.createEl(null,{className:"vjs-hd-control vjs-control",innerHTML:templateStore.get("avPlayer.customControlBarItem")({descr:"Toggle HD/SD Quality"}),role:"button",tabindex:0,"aria-live":"polite"})}),this.on("click",this.toggleSource)}});return ButtonToggleHd.asPlugin=function(fileViewer){return function(options){if(options.src_hd){var player=this,button=new ButtonToggleHd({player:player,fileViewer:fileViewer,isPlayingHd:options.hd_active});button.options=options,player.ready(function(){$(this.el()).addClass("vjs-hd-source"),options.hd_active&&$(this.el()).addClass("vjs-hd-playing"),player.controlBar.addChild(button)})}}},ButtonToggleHd.prototype.fixPreload=function(){var player=this._player;"none"===player.el().firstChild.preload&&(player.el().firstChild.preload="metadata")},ButtonToggleHd.prototype.switchSource=function(options){var player=this._player,playerEl=$(player.el()),wasPaused=player.paused(),hasStarted=playerEl.hasClass("vjs-has-started");this.fixPreload(),playerEl.find("source").remove(),player.poster(""),options.position&&$(player.tag).css("display","none"),player.src(options.src),player.ready(function(){player.one("loadedmetadata",function(){player.poster(options.poster),hasStarted&&playerEl.addClass("vjs-has-started")}.bind(player)),options.position&&player.one("loadeddata",function(){player.currentTime(options.position),wasPaused?player.pause():player.play()}),player.one("seeked",function(){$(player.tag).css("display","block")})})},ButtonToggleHd.prototype.toggleSource=function(){var player=this._player,playerEl=$(player.el()),options={position:player.tech.currentTime(),src:"",poster:""};this._isPlayingHd?(this._isPlayingHd=!1,this._fileViewer.getStorage().setItem("videoQualityHd",!1),options.src=this.options.src,options.poster=this.options.poster,playerEl.removeClass("vjs-hd-playing")):(this._isPlayingHd=!0,this._fileViewer.getStorage().setItem("videoQualityHd",!0),options.src=this.options.src_hd,options.poster=this.options.poster_hd,playerEl.addClass("vjs-hd-playing")),this.switchSource(options)},ButtonToggleHd}),define("video-view/button-youtube",["template-store-singleton","url"],function(templateStore,urlHelper){var videojs=window.videojs,ButtonYoutube=videojs.Button.extend({init:function(opts){this._fileViewer=opts.fileViewer,this._player=opts.player,videojs.Button.call(this,this._player,{el:videojs.Component.prototype.createEl(null,{className:"vjs-youtube-control vjs-control",innerHTML:templateStore.get("avPlayer.customControlBarItem")({descr:"Youtube"}),role:"button",tabindex:0,"aria-live":"polite"})}),this.on("click",this.openYoutubePage)}});return ButtonYoutube.asPlugin=function(fileViewer){return function(options){var player=this,button=new ButtonYoutube({player:player,fileViewer:fileViewer});player.ready(function(){player.controlBar.addChild(button)})}},ButtonYoutube.prototype.openYoutubePage=function(){var srcYoutube;this._fileViewer.analytics.send("files.fileviewer-web.file.gotoyoutube"),this._player.pause(),srcYoutube=urlHelper.addQueryParamToUrl(this._player.src(),{start:Math.round(this._player.currentTime()),autoplay:1}),window.open(srcYoutube,"_blank")},ButtonYoutube}),define("video-view/plugin-progress-tooltips",["template-store-singleton","jquery"],function(templateStore,$){var PluginProgressTooltips=function(options){var player=this,init=function(){$("#vjs-tip").remove();var tipHtml=templateStore.get("avPlayer.progressTooltip")();$(".vjs-progress-control").after(tipHtml),$(".vjs-progress-holder").on("mousemove",function(event){var minutes,seconds,seekBar,timeInSeconds,mousePosition;seekBar=player.controlBar.progressControl.seekBar,mousePosition=(event.pageX-$(seekBar.el()).offset().left)/seekBar.width(),timeInSeconds=mousePosition*player.duration(),timeInSeconds===player.duration()&&(timeInSeconds-=.1),minutes=Math.floor(timeInSeconds/60),seconds=Math.floor(timeInSeconds-60*minutes),10>seconds&&(seconds="0"+seconds),$("#vjs-tip-inner").text([minutes,":",seconds].join(""));var $el=$(".vjs-control-bar"),tooltipWidth=$("#vjs-tip").outerWidth(),left=event.pageX-$el.offset().left-Math.round(tooltipWidth/2);$("#vjs-tip").css("left",left+"px").css("display","block")}),$(".vjs-progress-holder, .vjs-play-control").on("mouseout",function(){$("#vjs-tip").css("display","none")})};this.on("loadedmetadata",init)};return PluginProgressTooltips}),define("video-view",["ajs","backbone","underscore","jquery","file","BaseViewer","instance-manager","file-types","template-store-singleton","keyboard","video-view/button-youtube","video-view/button-toggle-hd","video-view/button-presentation-mode","video-view/plugin-progress-tooltips"],function(AJS,Backbone,_,$,File,BaseViewer,InstanceManager,fileTypes,templateStore,keyboard,buttonYoutube,buttonToggleHd,buttonPresentationMode,pluginProgressTooltips){var playerManager=new InstanceManager(videojs,function(player){player.tech&&player.pause(),player.dispose()}),VideoView=BaseViewer.extend({id:"cp-video-preview",playerId:"cp-video-player",events:{"click .vjs-poster":"togglePlay"},initialize:function(){BaseViewer.prototype.initialize.apply(this,arguments);var type=this.model.get("type");this._paddingVertical=20,this._paddingScrollbar=40,this._paddingNavArrows=160,this._isPaused=!0,this._isVideo=fileTypes.isVideo(type),this._isAudio=fileTypes.isAudio(type),this._isYoutube=fileTypes.isYoutube(type),this._isAutoPlay=this._fileViewer.get("videoViewerAutoplay"),this._maxWidth=this._isVideo?1280:640,this._maxHeight=this._isVideo?720:640,this._minWidth=this._isVideo?160:120,this._minHeight=this._isVideo?90:120,this._hasHdSource=!!this.model.get("src_hd"),$(window).on("resize.videojs",_.throttle(this._handleResize.bind(this),50)),$(document).on("keydown.videoView",keyboard.createConditionalKeyHandler(this._handleKeyboardControl.bind(this)))},teardown:function(){$(window).off("resize.videojs",this._handleResize),$(document).off("keydown.videoView"),playerManager.destroy()},clickHitBackground:function(e){var hitBackground=e.target.getAttribute("id")===this.id;return hitBackground},setupMode:function(mode){$(".cp-toolbar-layer").hide()},_handleKeyboardControl:function(e){e.which!==keyboard.keys.SPACE&&e.which!==keyboard.keys.ENTER||(this.togglePlay(),e.preventDefault())},render:function(){var type=this.model.get("type");return this.$el.html(templateStore.get("avPlayer.playerBody")({src:this._getVideoSrc(),poster:this._getPosterSrc(),type:type,kind:this._isVideo?"video":"audio"})),playerManager.create(this.playerId,{plugins:this._registerPlugins(),controls:!0,ytFullScreenControls:!1,textTrackDisplay:!1,errorDisplay:!1,controlBar:{timeDivider:!1,remainingTimeDisplay:!1,liveDisplay:!1,fullscreenToggle:!1,muteToggle:!1,volumeMenuButton:!1,playbackRateMenuButton:!0,subtitlesButton:!1,captionsButton:!1,chaptersButton:!1},autoplay:this._isAutoPlay,preload:!0,width:this._maxWidth,height:this._maxHeight}).then(this._setupPlayer.bind(this)),this},play:function(){this._videoPlayer.play()},togglePlay:function(){this._videoPlayer&&this._isPaused?this._videoPlayer.play():this._videoPlayer&&this._videoPlayer.pause()},_refocusFileViewer:function(){if("IFRAME"===document.activeElement.tagName){var $container=$("#cp-container");$container.attr("tabindex",-1),$container.focus()}},handleResize:function(){this._handleResize()},_handleResize:function(){var containerWidth=Math.max(this.$el.width()-this._paddingNavArrows,this._minWidth),containerHeight=Math.max(this.$el.height()-this._paddingVertical,this._minHeight),$videoEl=$(this._videoPlayer.el()),videoWidth=$videoEl.width(),videoHeight=$videoEl.height(),ratio=Math.min(containerWidth/videoWidth,containerHeight/videoHeight),newWidth=Math.min(this._maxWidth,videoWidth*ratio),newHeight=Math.min(this._maxHeight,videoHeight*ratio);$videoEl.css("width",newWidth).css("height",newHeight)},_videoError:function(){var err=new Error("Media failed loading");err.title=AJS.I18n.getText("cp.error.media.default.header"),err.description=this.model.get("src"),err.icon="cp-multimedia-icon",this.viewerReady||($("#"+this.playerId).remove(),this.trigger("viewerFail",err))},_videoLoadedMetaData:function(){$("#"+this.playerId).addClass("vjs-ready"),this.trigger("viewerReady"),this.viewerReady=!0},_videoVolumeChange:function(){var storage=this._fileViewer.getStorage();storage.setItem("videoVolume",this._videoPlayer.volume())},_videoPlay:function(){this._refocusFileViewer(),this._isPaused=!1,$(this._videoPlayer.el()).removeClass("vjs-has-ended")},_videoPause:function(){this._refocusFileViewer(),this._isPaused=!0},_videoEnded:function(){$(this._videoPlayer.el()).addClass("vjs-has-ended")},_restoreVolumeSetting:function(){var storage=this._fileViewer.getStorage(),volumeLevel=parseFloat(storage.getItem("videoVolume"));isNaN(volumeLevel)||this._videoPlayer.volume(volumeLevel)},_restoreVideoPosterIfNotSet:function(){var currentPoster=this._videoPlayer.poster(),posterSrc=this._getPosterForCurrentQuality();this._isVideo&&!currentPoster&&this._videoPlayer.poster(posterSrc)},_handlePlayerReady:function(){this.viewerReady=!1,this._restoreVolumeSetting(),$(this._videoPlayer.el()).find(".vjs-control").each(function(idx,el){$(el).removeAttr("tabindex")}),this._videoPlayer.one("timeupdate",this._restoreVideoPosterIfNotSet.bind(this)),this._videoPlayer.on("loadedmetadata",this._videoLoadedMetaData.bind(this)),this._videoPlayer.on("volumechange",this._videoVolumeChange.bind(this)),this._videoPlayer.on("error",this._videoError.bind(this)),this._videoPlayer.on("play",this._videoPlay.bind(this)),this._videoPlayer.on("pause",this._videoPause.bind(this)),this._videoPlayer.on("ended",this._videoEnded.bind(this))},_registerPlugins:function(){var pluginsObject={};return videojs.plugin("pluginProgressTooltips",pluginProgressTooltips),pluginsObject.pluginProgressTooltips={},videojs.plugin("presentation",buttonPresentationMode.asPlugin(this._fileViewer)),pluginsObject.presentation={viewer:this},videojs.plugin("buttonToggleHd",buttonToggleHd.asPlugin(this._fileViewer)),pluginsObject.buttonToggleHd={src:this.model.get("src"),src_hd:this.model.get("src_hd")||"",poster:this.model.get("poster")||"",poster_hd:this.model.get("poster_hd")||this.model.get("poster")||"",hd_active:this._shouldUseHdSource()},this._isYoutube&&(videojs.plugin("buttonYoutube",buttonYoutube.asPlugin(this._fileViewer)),pluginsObject.buttonYoutube={}),pluginsObject},_setUpAudio:function($player){$player.addClass("vjs-audio"),this.model.get("poster")||$player.find(".vjs-poster").addClass("vjs-default-coverart")},_setUpYoutube:function($player){$(".iframeblocker").css("display","none")},_setupPlayer:function(player){var $player=$("#"+this.playerId);this._videoPlayer=player,this._handleResize(),this._isAudio&&this._setUpAudio($player),this._isYoutube&&this._setUpYoutube($player),player.ready(this._handlePlayerReady.bind(this))},_shouldUseHdSource:function(){if(!this._hasHdSource)return!1;var playHdDefault=this._fileViewer.getConfig().videoDefaultQualityHd,playHdUser=this._fileViewer.getStorage().getItem("videoQualityHd"),playHdEnabled="undefined"==typeof playHdUser||playHdUser,playHdSettings=(playHdDefault&&playHdEnabled)!==!1;return this._hasHdSource&&playHdSettings},_getPosterForCurrentQuality:function(){return this._shouldUseHdSource()?this.model.get("poster_hd")||this.model.get("poster")||"":this.model.get("poster")||""},_getPosterSrc:function(){return this._isAutoPlay&&this._isVideo?"":this._getPosterForCurrentQuality()},_getVideoSrc:function(){return this._shouldUseHdSource()?this.model.get("src_hd"):this.model.get("src")}});return VideoView}),function(){var FileViewer=require("file-viewer");FileViewer.registerPlugin("autoplay-videos",function(fileViewer){var totalFilesShown;fileViewer.on("fv.open",function(){totalFilesShown=0}),fileViewer.on("fv.changeFile",function(){totalFilesShown++,fileViewer.set("videoViewerAutoplay",1===totalFilesShown)})})}()}(function(){var FileViewer;return FileViewer="undefined"!=typeof module&&"exports"in module?require("./fileviewer.js"):window.require?window.FileViewer:window.FileViewer}());