!function(FileViewer){"use strict";var define=FileViewer.define,require=FileViewer.require;define("minimode/MinimodePanel",["jquery","ajs","backbone","minimode/ThumbnailView","template-store-singleton"],function($,AJS,Backbone,FileThumbnailView,templateStore){var FileMinimodeView=Backbone.View.extend({id:"cp-footer-minimode",initialize:function(options){this.subviews=[],this._fileViewer=options.fileViewer,this._panelView=options.panelView,this.listenTo(this.collection,"add reset",this.render),this.listenTo(this._panelView,"renderPanel",this._forceChromeRepaint),this.listenTo(this._panelView,"renderPanel",this.scrollToSelected),this.$minimode=$(templateStore.get("minimode")()),this.$minimode.appendTo(this.$el)},closeOldSubviews:function(){for(;this.subviews.length>0;){var view=this.subviews.pop();view.remove(),view.unbind()}},render:function(){return this.closeOldSubviews(),this.collection.each(function(model){var view=new FileThumbnailView({model:model,fileViewer:this._fileViewer,panelView:this._panelView});this.subviews.push(view),$(view.render().el).appendTo(this.$minimode)},this),this},scrollToSelected:function(){var file=this._fileViewer.getCurrentFile();this.subviews.forEach(function(view){if(view.model===file){var topPos=view.$el.get(0).offsetTop-59;topPos&&this.$el.scrollTop!==topPos&&this.$el.find("#cp-thumbnails").scrollTop(topPos)}}.bind(this))},_forceChromeRepaint:function(){var $img=$("#cp-img");if($img.length){var $preview=$img.closest("#cp-image-preview"),left=$preview.scrollLeft(),top=$preview.scrollTop();$img.css("display","none").height(),$img.css("display","inline-block"),$preview.scrollLeft(left),$preview.scrollTop(top)}}});return FileMinimodeView}),define("minimode/minimodePlugin",["minimode/MinimodeToggle","minimode/MinimodePanel"],function(MinimodeToggle,MinimodePanel){var minimodePlugin=function(fileViewer){var fileView=fileViewer.getView(),sinkView=fileView.fileSinkView,metaView=fileView.fileMetaView;fileViewer.getConfig().enableMiniMode&&(metaView.addLayerView("minimodeToggle",MinimodeToggle,{predicate:MinimodeToggle.predicate}),sinkView.addPanelView("minimode",MinimodePanel))};return minimodePlugin}),define("minimode/MinimodeToggle",["backbone","template-store-singleton"],function(Backbone,templateStore){var MinimodeToggle=Backbone.View.extend({events:{"click #cp-files-label":"_toggleMinimode"},initialize:function(options){this._fileViewer=options.fileViewer,this._sinkView=this._fileViewer.getView().fileSinkView},render:function(){return this.$el.html(templateStore.get("minimodeBanner")()),this._setShowAllFilesVisible(),this},_toggleMinimode:function(event){event.preventDefault();var analytics=this._fileViewer.analytics;this._sinkView.isPanelInitialized("minimode")?(this._sinkView.teardownPanel("minimode"),analytics.send("files.fileviewer-web.minimode.closed")):(this._sinkView.initializePanel("minimode"),analytics.send("files.fileviewer-web.minimode.opened")),this._setShowAllFilesVisible()},_setShowAllFilesVisible:function(){var visible=this._sinkView.isPanelInitialized("minimode");this.$(".cp-files-collapser.up").toggleClass("hidden",visible),this.$(".cp-files-collapser.down").toggleClass("hidden",!visible)}},{predicate:function(fileViewer){return fileViewer._fileState.collection.length>1}});return MinimodeToggle}),define("minimode/ThumbnailView",["ajs","backbone","jquery","underscore","file-types","icon-utils","template-store-singleton"],function(AJS,Backbone,$,_,fileTypes,iconUtils,templateStore){var ThumbnailView=Backbone.View.extend({className:"cp-thumbnail",tagName:"li",events:{click:"jumpToFile"},initialize:function(options){this._fileViewer=options.fileViewer,this.listenTo(this.model,"change",this.render),this.listenTo(options.panelView,"renderPanel",this.setSelected)},jumpToFile:function(event){event.preventDefault(),this._fileViewer.showFileWithCID(this.model.cid).then(function(){var currentViewer,contentView=this._fileViewer.getView().fileContentView;contentView.isLayerInitialized("content")&&(currentViewer=contentView.getLayerForName("content")._viewer,currentViewer&&currentViewer.play&&currentViewer.play())}.bind(this)).always(this._fileViewer.analytics.fn("files.fileviewer-web.minimode.thumbnail.clicked"))},setSelected:function(){var file=this._fileViewer._fileState.getCurrent();file===this.model?this.$el.addClass("selected"):this.$el.hasClass("selected")&&this.$el.removeClass("selected")},onThumbLoadError:function(ev){var el=$(ev.target);el.parent().removeClass("has-thumbnail"),el.remove()},render:function(){var type=this.model.get("type"),thumbnailSrc=this.model.get("thumbnail"),isImage=fileTypes.isImage(type),generateThumbnail=this._fileViewer.getConfig().generateThumbnail,$thumbnail=$(templateStore.get("placeholderThumbnail")({iconClass:iconUtils.getCssClass(type),title:this.model.get("title")}));return this.$el.empty().append($thumbnail),thumbnailSrc&&generateThumbnail?generateThumbnail(this.model).done(function(thumbSrc){$thumbnail.replaceWith(templateStore.get("thumbnail")({iconClass:iconUtils.getCssClass(type),thumbnailSrc:thumbSrc,title:this.model.get("title")})),this.$el.find("img").error(this.onThumbLoadError)}.bind(this)):(isImage||thumbnailSrc)&&($thumbnail.replaceWith(templateStore.get("thumbnail")({iconClass:iconUtils.getCssClass(type),thumbnailSrc:thumbnailSrc||this.model.get("src"),title:this.model.get("title")})),this.$el.find("img").error(this.onThumbLoadError)),this}});return ThumbnailView}),function(){var FileViewer=require("file-viewer"),minimodePlugin=require("minimode/minimodePlugin");FileViewer.registerPlugin("minimode",minimodePlugin)}()}(function(){var FileViewer;return FileViewer="undefined"!=typeof module&&"exports"in module?require("./fileviewer.js"):window.require?window.FileViewer:window.FileViewer}());