# FileViewer

FileViewer is Atlassian's powerful solution for viewing files on the web. It's both powerful and extendable yet easy-to-integrate.

To see a working example of a FileViewer integration, check out the example in `examples/bare_page/`.

There's an [integration guide](./docs/integration_guide.md) and [api documentation](./docs/api.md).

## Contributing

First of all, you need to setup your local dev environment.

You do that by doing the following things

1. `npm install`
2. `bower install`
3. `python -m SimpleHTTPServer 8080`

There's three major build tasks:

  - `grunt all`: Creates all target files
  - `grunt example`: Update the example page

## Upgrading PDFJS
 
- You can directly fetch the ``dist`` artifacts from the "nightly" build from https://github.com/mozilla/pdfjs-dist
- Or you can build from source:
  - Go to https://github.com/mozilla/pdf.js and follow the instructions under "Building PDF.js". 
- Run `grunt pdfjsmin` to create minified versions of PDF.js libraries.
- Look at the original file headers to see if we have applied a patch that needs to be carried forward. 

Run the unit tests with `npm run spec`, the functional tests with `npm run func`.

If you want to run the tests without building the dependencies, run `karma start --single-run` or `support/functest`.
Run `karma start` to continuously run the unit tests on change.

To prepare a new FileViewer release run `VERSION=x.x.x npm run build` which will
run eslint, run the spec tests, update the VERSION in fileviewer.js, package.json and bower.json.

- [Repository](https://stash.atlassian.com/projects/DV/repos/dt-fileviewer/browse)
- [Continuous Ingegration](https://collaboration-bamboo.internal.atlassian.com/browse/FIL-FVW)
- [Issue Tracking](https://jira.atlassian.com/browse/FIL/component/32993/?selectedTab=com.atlassian.jira.jira-projects-plugin:component-summary-panel)
- [File Viewer documentation in EAC](https://extranet.atlassian.com/display/FIL/dt-fileviewer)

## NPM publishing

Don't forget to

```
npm publish
```

## Examples

Once your local server is running and the project is built you can point your browser to [http://localhost:8080/examples/](http://localhost:8080/examples/)
