/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.feedback;

import com.atlassian.feedback.DefaultIssueCollectorUrlManager;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class FeedbackButtonWebResourceDataProvider
implements WebResourceDataProvider {
    private final FeatureManager featureManager;
    private final DefaultIssueCollectorUrlManager defaultIssueCollectorUrlManager;

    public FeedbackButtonWebResourceDataProvider(@ComponentImport FeatureManager featureManager, DefaultIssueCollectorUrlManager defaultIssueCollectorUrlManager) {
        this.featureManager = featureManager;
        this.defaultIssueCollectorUrlManager = defaultIssueCollectorUrlManager;
    }

    public Jsonable get() {
        JSONObject jsonData = this.getJsonData();
        return writer -> {
            try {
                jsonData.write(writer);
            }
            catch (JSONException e) {
                throw new Jsonable.JsonMappingException((Throwable)e);
            }
        };
    }

    private JSONObject getJsonData() {
        boolean isHeaderFeedbackButtonEnabled = this.featureManager.isEnabled("com.atlassian.feedback.feedback-button-move-to-header-enable") && !this.featureManager.isEnabled("com.atlassian.feedback.header-feedback-button-disable");
        HashMap values = Maps.newHashMap();
        values.put("isHeaderFeedbackButtonEnabled", isHeaderFeedbackButtonEnabled);
        Stream.of(DefaultIssueCollectorUrlManager.JiraType.values()).forEach(t -> values.put(t.getKey(), this.defaultIssueCollectorUrlManager.getUrl((DefaultIssueCollectorUrlManager.JiraType)((Object)t))));
        return new JSONObject((Map)values);
    }
}

