/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.feedback;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import java.net.MalformedURLException;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class DefaultIssueCollectorUrlManager {
    private final ApplicationProperties jiraApplicationProperties;

    @Inject
    public DefaultIssueCollectorUrlManager(@ComponentImport ApplicationProperties jiraApplicationProperties) {
        this.jiraApplicationProperties = jiraApplicationProperties;
    }

    public String getUrl(JiraType type) {
        String dirtyUrl = this.jiraApplicationProperties.getString(type.getKey());
        if (dirtyUrl == null) {
            return type.getDefaultUrl();
        }
        try {
            URL url = new URL(dirtyUrl);
            return url.toExternalForm();
        }
        catch (MalformedURLException e) {
            return type.getDefaultUrl();
        }
    }

    @VisibleForTesting
    public void setUrl(JiraType type, String dirtyUrl) throws MalformedURLException {
        URL url = new URL(dirtyUrl);
        this.jiraApplicationProperties.setString(type.getKey(), url.toExternalForm());
    }

    public static enum JiraType {
        DEFAULT("jira.feedback.plugin.issue.collector.default", "https://jira.atlassian.com/s/576e9ab86257d4f65f6ea5b6dd50de44-T/en_UK3ljiw5/71006/b6b48b2829824b869586ac216d119363/2.0.11/_/download/batch/com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:issuecollector-embededjs/com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:issuecollector-embededjs.js?locale=en-UK&collectorId=abbf546d"),
        SERVICE_DESK("jira.feedback.plugin.issue.collector.service.desk", "https://jira.atlassian.com/s/576e9ab86257d4f65f6ea5b6dd50de44-T/en_UK3ljiw5/71006/b6b48b2829824b869586ac216d119363/2.0.11/_/download/batch/com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:issuecollector/com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:issuecollector.js?locale=en-UK&collectorId=a698db21"),
        SOFTWARE("jira.feedback.plugin.issue.collector.software", DEFAULT.getDefaultUrl()),
        CORE("jira.feedback.plugin.issue.collector.core", DEFAULT.getDefaultUrl());

        private final String key;
        private final String url;

        private JiraType(String key, String url) {
            this.key = key;
            this.url = url;
        }

        public String getKey() {
            return this.key;
        }

        protected String getDefaultUrl() {
            return this.url;
        }
    }
}

