/* eslint-disable max-len */
AJS.test.require(["com.atlassian.jira.plugins.jira-editor-plugin:resources"], function () {
    var $ = require('jquery');
    var _ = require('underscore');
    var WikiToolbarOperation = require('jira/richeditor/wiki-adapter/wiki-toolbar-operation');
    var events = require('jira/util/events');

    module("wiki-toolbar-operation", {
        setup: function () {

            this.buildElement = function (operation, shortcut, properties) {
                var el = $('<a>', {'data-operation': operation});

                if (shortcut) {
                    el.attr('data-shortcut', shortcut);
                }

                if (properties) {
                    _.pairs(properties).forEach(
                        function (pair) {
                            el.attr('data-' + pair[0], pair[1]);
                        }
                    );
                }

                return el;
            };

            this.buildAttachmentElement = function (cssClass, attachmentType, attachmentName) {
                var element = $('<div>', {"class": cssClass});

                if (attachmentName || attachmentType) {
                    var elementInside = $('<a>');
                    if (attachmentType) {
                        elementInside.attr("data-attachment-type", attachmentType);
                    }
                    if (attachmentName) {
                        elementInside.append($('<div>', {"class": "wiki-edit-attachment-name"}).text(attachmentName));
                    }
                    element.append(elementInside);
                }

                return element;
            };

            this.mockedContext = AJS.test.mockableModuleContext();
            this.sandbox = sinon.sandbox.create({useFakeServer: true});

            this.$element = this.buildElement('operation1', {
                'shortcut': 'shortcut1',
                'color': 'color1',
                'someproperty': 'something'
            });
            this.$wikiTextarea = $('<textarea>');

            $("#qunit-fixture").append(this.$wikiTextarea);

            this.$uploadInProgressHtml =
                $('<div><div class="toolbar"><div class="wiki-edit-dropdown-image"><a href ="#" class="wiki-attachment-browse">browse</a></div></div><div duitype="dndattachment/progressbars/AttachmentsUploadProgressBar" class="-dui-type-parsed attachments-upload-progress-bar">' +
                    '    <div class="upload-progress-bar__thumbnail upload-progress-bar__thumbnail_image">' +
                    '        <div class="upload-progress-bar__progress-bar">' +
                    '            <span class="upload-progress-bar__bar"></span>' +
                    '        </div>' +
                    '        <img src="blob:http%3A//localhost%3A2990/39aac0df-8071-49b7-b803-32bfcd05ddcf">' +
                    '    </div>' +
                    '    <dl>' +
                    '        <dt>' +
                    '            <span class="upload-progress-bar__file-name">test2.png</span>' +
                    '        </dt>' +
                    '        <dd class="upload-progress-bar__file-size">3 kB</dd>' +
                    '        <dd class="upload-progress-bar__upload-control"><span>Cancel</span></dd>' +
                    '        <dd class="upload-progress-bar__error-message"></dd>' +
                    '        <dd class="attachment-date"><time class="livestamp" datetime="2016-07-22T10:36:57.257Z"></time></dd>' +
                    '    </dl>' +
                    '</div></div>');
            $("#qunit-fixture").append(this.$uploadInProgressHtml);
            this.$buttonUpload = $($("#qunit-fixture").find('.toolbar .wiki-attachment-browse')[0]);
            this.$toolbar = $(this.$uploadInProgressHtml.find('.toolbar')[0]);
            this.$browseButton = $(this.$toolbar.find("a")[0]);

            this.$scopeUploadInProgressHtml =
                $('<div class="jira-dialog"><div class="toolbar"><div class="wiki-edit-dropdown-image"><a href ="#" class="wiki-attachment-browse">browse</a></div></div><div duitype="dndattachment/progressbars/AttachmentsUploadProgressBar" class="-dui-type-parsed attachments-upload-progress-bar">' +
                    '    <div class="upload-progress-bar__thumbnail upload-progress-bar__thumbnail_image">' +
                    '        <div class="upload-progress-bar__progress-bar">' +
                    '            <span class="upload-progress-bar__bar"></span>' +
                    '        </div>' +
                    '        <img src="Scoped-blob:http%3A//localhost%3A2990/39aac0df-8071-49b7-b803-32bfcd05ddcf">' +
                    '    </div>' +
                    '    <dl>' +
                    '        <dt>' +
                    '            <span class="upload-progress-bar__file-name">test2.png</span>' +
                    '        </dt>' +
                    '        <dd class="upload-progress-bar__file-size">3 kB</dd>' +
                    '        <dd class="upload-progress-bar__upload-control"><span>Cancel</span></dd>' +
                    '        <dd class="upload-progress-bar__error-message"></dd>' +
                    '        <dd class="attachment-date"><time class="livestamp" datetime="2016-07-22T10:36:57.257Z"></time></dd>' +
                    '    </dl>' +
                    '</div></div>');
            $("#qunit-fixture").append(this.$scopeUploadInProgressHtml);
            this.$scopeButtonUpload = $($("#qunit-fixture").find('.jira-dialog .toolbar .wiki-attachment-browse')[0]);

            this.editorVisible = true;
            this.editor = {
                isVisible: function () {
                    return this.editorVisible;
                }.bind(this)
            };
            this.editor.executeOperation = this.sandbox.spy();

            this.$sdAttachmentProgressBar =
                $('<div class="jira-dialog servicedesk"><div class="toolbar"><div class="wiki-edit-dropdown-image"><a href ="#" class="wiki-attachment-browse">browse</a></div></div><div class="temp-upload-progress-bar__parent-container">'+
                '    <div class="temp-upload-progress-bar__container">'+
                '        <div class="upload-progress-bar__thumbnail upload-progress-bar__thumbnail_image">'+
                '            <img src="blob:http://localhost:2990/servicedesk">'+
                '        </div>'+
                '        <div class="upload-progress-bar__progress-bar upload-progress-bar__progress-bar-fade">'+
                '            <span class="upload-progress-bar__bar" style="width: 100%;"> </span>'+
                '        </div>'+
                '        <div class="upload-progress-bar__error">'+
                '            <div class="upload-progress-bar__error-indicator"><span class="aui-icon aui-icon-large aui-iconfont-error">Upload error</span></div>'+
                '            <div class="upload-progress-bar__error-text">Upload failed</div>'+
                '        </div>'+
                '        <div class="upload-progress-bar__upload-mask"></div>'+
                '        <div class="upload-progress-bar__control">'+
                '            <button type="button" class="aui-button aui-button-subtle aui-button-compact">'+
                '                <span class="aui-icon aui-icon-small aui-iconfont-close-dialog">'+
                '                    <div class="button-text" aria-label="Remove attachment"></div>'+
                '                    <div class="file-name" aria-label="servicedesk1.png"></div>'+
                '                    <div class="error-message"></div>'+
                '                </span>'+
                '            </button>'+
                '        </div>'+
                '        <div class="upload-progress-bar__progress-bar upload-progress-bar__progress-bar-fade">'+
                '            <span class="upload-progress-bar__bar" style="width: 100%;"> </span>'+
                '        </div> '+
                '    </div>'+
                '    <div class="upload-progress-bar_file-name-container">'+
                '        <span class="upload-progress-bar__file-name" original-title="servicedesk1.png | 272 kB">servicedesk1.png</span>'+
                '    </div> '+
                '</div></div>');
            $("#qunit-fixture").append(this.$sdAttachmentProgressBar);
            this.$sdButtonUpload = $($("#qunit-fixture").find('.jira-dialog.servicedesk .toolbar .wiki-attachment-browse')[0]);
        },
        teardown: function () {
            this.sandbox.restore();
        }
    });

    test("Operation name is extracted from element attribute", function () {
        var operation = new WikiToolbarOperation(this.$element, this.$wikiTextarea);

        equal(operation.getName(), 'operation1', 'Operation name should be set from data-operation attribute');
    });

    test("Operation name is set to attachment on attachment dropdowns", function () {
        equal(new WikiToolbarOperation(this.buildAttachmentElement("wiki-edit-dropdown-image"), this.$wikiTextarea).getName(), 'attachment', 'Operation name should be set to attachment');
        equal(new WikiToolbarOperation(this.buildAttachmentElement("wiki-edit-dropdown-attachment"), this.$wikiTextarea).getName(), 'attachment', 'Operation name should be set to attachment');
    });

    test("Operation name is set to icon when data-operation describes an icon", function () {
        equal(new WikiToolbarOperation(this.buildElement(":)"), this.$wikiTextarea).getName(), 'icon', 'Operation name should be set to icon');
        equal(new WikiToolbarOperation(this.buildElement(":("), this.$wikiTextarea).getName(), 'icon', 'Operation name should be set to icon');
        equal(new WikiToolbarOperation(this.buildElement(":P"), this.$wikiTextarea).getName(), 'icon', 'Operation name should be set to icon');
        equal(new WikiToolbarOperation(this.buildElement(":D"), this.$wikiTextarea).getName(), 'icon', 'Operation name should be set to icon');
        equal(new WikiToolbarOperation(this.buildElement(";)"), this.$wikiTextarea).getName(), 'icon', 'Operation name should be set to icon');
        equal(new WikiToolbarOperation(this.buildElement("(y)"), this.$wikiTextarea).getName(), 'icon', 'Operation name should be set to icon');
        equal(new WikiToolbarOperation(this.buildElement("(n)"), this.$wikiTextarea).getName(), 'icon', 'Operation name should be set to icon');
        equal(new WikiToolbarOperation(this.buildElement("(i)"), this.$wikiTextarea).getName(), 'icon', 'Operation name should be set to icon');
        equal(new WikiToolbarOperation(this.buildElement("(/)"), this.$wikiTextarea).getName(), 'icon', 'Operation name should be set to icon');
        equal(new WikiToolbarOperation(this.buildElement("(x)"), this.$wikiTextarea).getName(), 'icon', 'Operation name should be set to icon');
        equal(new WikiToolbarOperation(this.buildElement("(!)"), this.$wikiTextarea).getName(), 'icon', 'Operation name should be set to icon');
        equal(new WikiToolbarOperation(this.buildElement("(+)"), this.$wikiTextarea).getName(), 'icon', 'Operation name should be set to icon');
        equal(new WikiToolbarOperation(this.buildElement("(-)"), this.$wikiTextarea).getName(), 'icon', 'Operation name should be set to icon');
        equal(new WikiToolbarOperation(this.buildElement("(?)"), this.$wikiTextarea).getName(), 'icon', 'Operation name should be set to icon');
        equal(new WikiToolbarOperation(this.buildElement("(on)"), this.$wikiTextarea).getName(), 'icon', 'Operation name should be set to icon');
        equal(new WikiToolbarOperation(this.buildElement("(off)"), this.$wikiTextarea).getName(), 'icon', 'Operation name should be set to icon');
        equal(new WikiToolbarOperation(this.buildElement("(*)"), this.$wikiTextarea).getName(), 'icon', 'Operation name should be set to icon');
        equal(new WikiToolbarOperation(this.buildElement("(*r)"), this.$wikiTextarea).getName(), 'icon', 'Operation name should be set to icon');
        equal(new WikiToolbarOperation(this.buildElement("(*g)"), this.$wikiTextarea).getName(), 'icon', 'Operation name should be set to icon');
        equal(new WikiToolbarOperation(this.buildElement("(*b)"), this.$wikiTextarea).getName(), 'icon', 'Operation name should be set to icon');
        equal(new WikiToolbarOperation(this.buildElement("(*y)"), this.$wikiTextarea).getName(), 'icon', 'Operation name should be set to icon');
        equal(new WikiToolbarOperation(this.buildElement("(flag)"), this.$wikiTextarea).getName(), 'icon', 'Operation name should be set to icon');
        equal(new WikiToolbarOperation(this.buildElement("(flagoff)"), this.$wikiTextarea).getName(), 'icon', 'Operation name should be set to icon');
    });

    test("Operation name is set to icon when data-operation describes an icon", function () {
        propEqual(new WikiToolbarOperation(this.buildElement(":)"), this.$wikiTextarea).getParams(), {icon: ":)"}, 'Proper icon should be inserted into returned parameters');
        propEqual(new WikiToolbarOperation(this.buildElement(":("), this.$wikiTextarea).getParams(), {icon: ":("}, 'Proper icon should be inserted into returned parameters');
        propEqual(new WikiToolbarOperation(this.buildElement(":P"), this.$wikiTextarea).getParams(), {icon: ":P"}, 'Proper icon should be inserted into returned parameters');
        propEqual(new WikiToolbarOperation(this.buildElement(":D"), this.$wikiTextarea).getParams(), {icon: ":D"}, 'Proper icon should be inserted into returned parameters');
        propEqual(new WikiToolbarOperation(this.buildElement(";)"), this.$wikiTextarea).getParams(), {icon: ";)"}, 'Proper icon should be inserted into returned parameters');
        propEqual(new WikiToolbarOperation(this.buildElement("(y)"), this.$wikiTextarea).getParams(), {icon: "(y)"}, 'Proper icon should be inserted into returned parameters');
        propEqual(new WikiToolbarOperation(this.buildElement("(n)"), this.$wikiTextarea).getParams(), {icon: "(n)"}, 'Proper icon should be inserted into returned parameters');
        propEqual(new WikiToolbarOperation(this.buildElement("(i)"), this.$wikiTextarea).getParams(), {icon: "(i)"}, 'Proper icon should be inserted into returned parameters');
        propEqual(new WikiToolbarOperation(this.buildElement("(/)"), this.$wikiTextarea).getParams(), {icon: "(/)"}, 'Proper icon should be inserted into returned parameters');
        propEqual(new WikiToolbarOperation(this.buildElement("(x)"), this.$wikiTextarea).getParams(), {icon: "(x)"}, 'Proper icon should be inserted into returned parameters');
        propEqual(new WikiToolbarOperation(this.buildElement("(!)"), this.$wikiTextarea).getParams(), {icon: "(!)"}, 'Proper icon should be inserted into returned parameters');
        propEqual(new WikiToolbarOperation(this.buildElement("(+)"), this.$wikiTextarea).getParams(), {icon: "(+)"}, 'Proper icon should be inserted into returned parameters');
        propEqual(new WikiToolbarOperation(this.buildElement("(-)"), this.$wikiTextarea).getParams(), {icon: "(-)"}, 'Proper icon should be inserted into returned parameters');
        propEqual(new WikiToolbarOperation(this.buildElement("(?)"), this.$wikiTextarea).getParams(), {icon: "(?)"}, 'Proper icon should be inserted into returned parameters');
        propEqual(new WikiToolbarOperation(this.buildElement("(on)"), this.$wikiTextarea).getParams(), {icon: "(on)"}, 'Proper icon should be inserted into returned parameters');
        propEqual(new WikiToolbarOperation(this.buildElement("(off)"), this.$wikiTextarea).getParams(), {icon: "(off)"}, 'Proper icon should be inserted into returned parameters');
        propEqual(new WikiToolbarOperation(this.buildElement("(*)"), this.$wikiTextarea).getParams(), {icon: "(*)"}, 'Proper icon should be inserted into returned parameters');
        propEqual(new WikiToolbarOperation(this.buildElement("(*r)"), this.$wikiTextarea).getParams(), {icon: "(*r)"}, 'Proper icon should be inserted into returned parameters');
        propEqual(new WikiToolbarOperation(this.buildElement("(*g)"), this.$wikiTextarea).getParams(), {icon: "(*g)"}, 'Proper icon should be inserted into returned parameters');
        propEqual(new WikiToolbarOperation(this.buildElement("(*b)"), this.$wikiTextarea).getParams(), {icon: "(*b)"}, 'Proper icon should be inserted into returned parameters');
        propEqual(new WikiToolbarOperation(this.buildElement("(*y)"), this.$wikiTextarea).getParams(), {icon: "(*y)"}, 'Proper icon should be inserted into returned parameters');
        propEqual(new WikiToolbarOperation(this.buildElement("(flag)"), this.$wikiTextarea).getParams(), {icon: "(flag)"}, 'Proper icon should be inserted into returned parameters');
        propEqual(new WikiToolbarOperation(this.buildElement("(flagoff)"), this.$wikiTextarea).getParams(), {icon: "(flagoff)"}, 'Proper icon should be inserted into returned parameters');
    });

    test("Color operation contains color value as parameter", function () {
        propEqual(new WikiToolbarOperation(this.buildElement("color", '', {color: 'red'}), this.$wikiTextarea).getParams(), {color: "red", 'data-color': "red"}, 'Red should be set as color parameter');

    });

    test("Supported params are parsed from dom and returned by getParams() method", function () {
        propEqual(new WikiToolbarOperation(this.buildElement("test", '', {color: 'red'}), this.$wikiTextarea).getParams(), {'data-color': "red"});
    });

    test("Not supported params are not parsed from dom and not returned by getParams() method", function () {
        propEqual(new WikiToolbarOperation(this.buildElement("test", '', {otherparam: 'red'}), this.$wikiTextarea).getParams(), {});
    });

    test("Not supported params are not parsed from dom and not returned by getParams() method", function () {
        equal(new WikiToolbarOperation(this.buildElement("test", 'someshortcut'), this.$wikiTextarea).getShortcut(), 'someshortcut');
    });

    test("Proper editor operation is constructed from WikiToolbarOperation", function () {
        var editorOperation = new WikiToolbarOperation(this.buildElement("test", 'someshortcut'), this.$wikiTextarea).getEditorOperation();

        equal(editorOperation.getName(), 'test');
        propEqual(editorOperation.getParams(), {});
        equal(editorOperation.getShortcut(), 'someshortcut');
    });

    test("Execute is executed with proper parameters", function () {
        new WikiToolbarOperation(this.buildElement("test", 'someshortcut'), this.$wikiTextarea).execute(this.editor);

        sinon.assert.calledOnce(this.editor.executeOperation);
        sinon.assert.calledWith(this.editor.executeOperation, 'test', {});
    });

    test("getParams for attachment should not add attachment property when no additional parameters are passed", function (assert) {
        var operation = new WikiToolbarOperation(this.buildAttachmentElement("wiki-edit-dropdown-image"), this.$wikiTextarea);
        var params = operation.getParams();

        assert.deepEqual(params, {});
    });

    test("getParams for attachment should not add attachment property when either $attachmentElement or attachmentName is missing", function (assert) {
        var operation = new WikiToolbarOperation(this.buildAttachmentElement("wiki-edit-dropdown-image"), this.$wikiTextarea);
        var params = operation.getParams({$attachmentElement: this.$browseButton});

        assert.deepEqual(params, {});

        params = operation.getParams({attachmentName: 'testName'});

        assert.deepEqual(params, {});
    });

    test("getParams for browse button should return empty params for image attachmentType", function (assert) {
        var operation = new WikiToolbarOperation(this.buildAttachmentElement("wiki-edit-dropdown-image"), this.$wikiTextarea);
        this.sandbox.stub(operation, "getHrefFromDom", function () {
            return undefined;
        });
        var params = operation.getParams({$attachmentElement: this.$browseButton, attachmentName: 'testName', attachmentType: 'image'});

        assert.deepEqual(params, {});
    });

    test("getParams for should pass on attachment parameter for attachment operation", function (assert) {
        var operation = new WikiToolbarOperation(this.buildAttachmentElement("wiki-edit-dropdown-image"), this.$wikiTextarea);
        var attachment = "example param";
        var params = operation.getParams({attachment: attachment});

        assert.deepEqual(params, {attachment: attachment});
    });

    test("getParams for attachment should not add attachment property when getHrefFromDom did not found element in dom and fileType is image", function (assert) {
        var attachmentDropdown = this.buildAttachmentElement("wiki-edit-dropdown-image", "image", "test2.png");
        var attachmentLink = $(attachmentDropdown.find('a'));
        var operation = new WikiToolbarOperation(attachmentDropdown, this.$wikiTextarea);

        this.sandbox.stub(operation, "getHrefFromDom", function () {
            return undefined;
        });
        var params = operation.getParams({$attachmentElement: attachmentLink, attachmentName: 'testName', attachmentType: 'image'});

        sinon.assert.calledOnce(operation.getHrefFromDom);
        assert.deepEqual(params, {});
    });

    test("getParams for attachment should not add attachment property when getHrefFromDom did not found element in dom and fileType is not image", function (assert) {
        var attachmentDropdown = this.buildAttachmentElement("wiki-edit-dropdown-image", "image", "test2.png");
        var attachmentLink = $(attachmentDropdown.find('a'));
        var operation = new WikiToolbarOperation(attachmentDropdown, this.$wikiTextarea);

        this.sandbox.stub(operation, "getHrefFromDom", function () {
            return undefined;
        });
        var params = operation.getParams({$attachmentElement: attachmentLink, attachmentName: 'testName', attachmentType: 'file'});

        assert.deepEqual(params, {attachment: '<span class="nobr"><a title="testName" href="undefined" data-filename="testName">testName<sup><img class="rendericon" width="7" height="7" border="0" align="absmiddle" alt="" src="/jira/images/icons/link_attachment_7.gif"></sup></a></span>'});
    });

    test("execute for browse button should not call editor.executeOperation", function (assert) {
        var attachmentDropdown = this.buildAttachmentElement("wiki-edit-dropdown-image");
        var attachmentLink = $(attachmentDropdown.find('a'));
        var operation = new WikiToolbarOperation(attachmentDropdown, this.$wikiTextarea);
        sinon.sandbox.stub(operation, "_isAttachment").returns(true);

        operation.execute(this.editor, {element: attachmentLink});

        sinon.assert.calledOnce(operation._isAttachment);
        sinon.assert.notCalled(this.editor.executeOperation);
    });

    test("When triggering button has data-attachment-type data with image then editor.executeOperation should be executed", function () {
        var attachmentDropdown = this.buildAttachmentElement("wiki-edit-dropdown-image", "image", "test2.png");
        var attachmentLink = $(attachmentDropdown.find('a'));
        var operation = new WikiToolbarOperation(attachmentDropdown, this.$wikiTextarea);
        operation.execute(this.editor, {element: attachmentLink});

        sinon.assert.calledOnce(this.editor.executeOperation);
        sinon.assert.calledWith(this.editor.executeOperation, 'attachment', {attachment: '<img style="border: 0px solid black" src="blob:http%3A//localhost%3A2990/39aac0df-8071-49b7-b803-32bfcd05ddcf" data-filename="test2.png">'});
    });

    test("When triggering button has data-attachment-type data with file then editor.executeOperation should be executed", function () {
        var attachmentDropdown = this.buildAttachmentElement("wiki-edit-dropdown-image", "file", "file.xls");
        var attachmentLink = $(attachmentDropdown.find('a'));
        var operation = new WikiToolbarOperation(attachmentDropdown, this.$wikiTextarea);
        operation.execute(this.editor, {element: attachmentLink});

        sinon.assert.calledOnce(this.editor.executeOperation);
        sinon.assert.calledWith(this.editor.executeOperation, 'attachment', {attachment: '<span class="nobr"><a title="file.xls" href="undefined" data-filename="file.xls">file.xls<sup><img class="rendericon" width="7" height="7" border="0" align="absmiddle" alt="" src="/jira/images/icons/link_attachment_7.gif"></sup></a></span>'});
    });

    test("Should be able to retrieve image href from dom unscoped", function () {
        var href = WikiToolbarOperation.prototype.getHrefFromDom("test2.png", this.$buttonUpload);
        equal(href, "blob:http%3A//localhost%3A2990/39aac0df-8071-49b7-b803-32bfcd05ddcf", "Should extract href from img");
    });

    test("Should be able to retrieve image href from dom scoped to .jira-dialog", function () {
        var href = WikiToolbarOperation.prototype.getHrefFromDom("test2.png", this.$scopeButtonUpload, true);
        equal(href, "Scoped-blob:http%3A//localhost%3A2990/39aac0df-8071-49b7-b803-32bfcd05ddcf", "Should extract href from img");
    });

    test("Should be able to retrieve image href from dom in Service Desk upload dialog", function () {
        var href = WikiToolbarOperation.prototype.getHrefFromDom("servicedesk1.png", this.$sdButtonUpload, true);
        equal(href, "blob:http://localhost:2990/servicedesk", "Should extract href from img for servicedesk");
    });

    test("Triggering wikiAttachmentForPageReceived should result in editor.executeOperation", function () {
        var operation = new WikiToolbarOperation(this.buildAttachmentElement("wiki-edit-dropdown-image"), this.$wikiTextarea);
        operation.bindEvents(this.editor);
        var url = "someUrl";
        sinon.sandbox.stub(window.URL, "createObjectURL").returns(url);

        events.trigger("wikiAttachmentForPageReceived", {
            files: [{name: "test.png"}],
            wikiTextfield: this.$wikiTextarea.get(0)
        });

        sinon.assert.calledOnce(this.editor.executeOperation);
        sinon.assert.calledWith(this.editor.executeOperation, 'attachment', {attachment: '<img style="border: 0px solid black" src="'+url+'" data-filename="test.png">'});

        operation.unbindEvents();
        this.editor.executeOperation.reset();

        events.trigger("wikiAttachmentForPageReceived", {
            files: [{name: "test.png"}],
            wikiTextfield: this.$wikiTextarea.get(0)
        });

        sinon.assert.notCalled(this.editor.executeOperation);
    });

    test("Triggering wikiAttachmentForPageReceived should be skipped if editor is not visible", function () {
        var operation = new WikiToolbarOperation(this.buildAttachmentElement("wiki-edit-dropdown-image"), this.$wikiTextarea);
        operation.bindEvents(this.editor);
        var url = "someUrl";
        sinon.sandbox.stub(window.URL, "createObjectURL").returns(url);

        events.trigger("wikiAttachmentForPageReceived", {
            files: [{name: "test.png"}],
            wikiTextfield: this.$wikiTextarea.get(0)
        });

        sinon.assert.calledOnce(this.editor.executeOperation);
        sinon.assert.calledWith(this.editor.executeOperation, 'attachment', {attachment: '<img style="border: 0px solid black" src="'+url+'" data-filename="test.png">'});

        this.editor.executeOperation.reset();
        this.editorVisible = false;

        events.trigger("wikiAttachmentForPageReceived", {
            files: [{name: "test.png"}],
            wikiTextfield: this.$wikiTextarea.get(0)
        });

        sinon.assert.notCalled(this.editor.executeOperation);
    });
});