define('jira/richeditor/wiki-adapter/toolbar-parser',[
    'jquery',
    'jira/richeditor/wiki-adapter/wiki-toolbar-operation'
], function (
    jQuery,
    WikiToolbarOperation
) {
    return function ($toolbarParent, $wikiTextarea) {
        var skipOperationsFilter = function () {
            var skipOperations = ['color-parameter'];
            var operationName = jQuery(this).attr('data-operation');
            return skipOperations.indexOf(operationName) < 0;
        };

        var operations = jQuery.map($toolbarParent.find('a[data-operation]').filter(skipOperationsFilter), function (el) {
            return new WikiToolbarOperation(jQuery(el), $wikiTextarea);
        });

        var attachmentDropdown = $toolbarParent.find(
            ".wiki-edit-dropdown-image, " +
            ".wiki-edit-dropdown-attachment"
        );
        if (attachmentDropdown.length > 0) {
            operations.push(new WikiToolbarOperation(jQuery(attachmentDropdown), $wikiTextarea));
        }

        return operations;
    };
});