AJS.test.require(['com.atlassian.jira.plugins.jira-editor-plugin:resources'], function () {

    var $ = require('jquery');

    module("toolbar-parser", {
        setup: function() {

            var createLink = function (dataOperation, dataShortcut){
                var ret = $('<a>');
                if( dataOperation ){
                    ret.attr('data-operation', dataOperation);
                }
                if( dataShortcut ){
                    ret.attr('data-shortcut', dataShortcut);
                }
                return ret;
            };
            var createAttachmentItem = function (cssClass){
                return $('<div>', {"class": cssClass});
            };

            this.toolbarParser = require('jira/richeditor/wiki-adapter/toolbar-parser');

            this.html3operations = $('<div>');
            this.html3operations.append(createLink('operation1', 'shortcut1'));
            this.html3operations.append(createLink('operation2', 'shortcut2'));
            this.html3operations.append(createLink('operation3', 'shortcut3'));

            this.html2operations = $('<div>');
            this.html2operations.append(createLink('operation1', 'shortcut1'));
            this.html2operations.append(createLink());
            this.html2operations.append(createLink('operation3', 'shortcut3'));

            this.htmlOperationsWithAttachments1 = $('<div>');
            this.htmlOperationsWithAttachments1.append(createLink('operation1', 'shortcut1'));
            this.htmlOperationsWithAttachments1.append(createLink('operation2', 'shortcut2'));
            this.htmlOperationsWithAttachments1.append(createAttachmentItem('wiki-edit-dropdown-image'));

            this.htmlOperationsWithAttachments2 = $('<div>');
            this.htmlOperationsWithAttachments2.append(createLink('operation1', 'shortcut1'));
            this.htmlOperationsWithAttachments2.append(createLink('operation2', 'shortcut2'));
            this.htmlOperationsWithAttachments2.append(createAttachmentItem('wiki-edit-dropdown-attachment'));

            this.$wikiTextarea = $('<textarea>');
        }
    });

    test('Parser returns all links with data-operation attribute', function() {
        var operations = this.toolbarParser(this.html3operations);
        equal(operations.length, 3, "There should be 3 operations.");
    });

    test('Parser will pass $wikiTextarea to constructed operations', function() {
        var operations = this.toolbarParser(this.html3operations, this.$wikiTextarea);
        equal(operations[0].$wikiTextarea, this.$wikiTextarea, "$wikiTextarea should be passed to constructed operations");
        equal(operations[1].$wikiTextarea, this.$wikiTextarea, "$wikiTextarea should be passed to constructed operations");
        equal(operations[2].$wikiTextarea, this.$wikiTextarea, "$wikiTextarea should be passed to constructed operations");
    });


    test('Parser returns links with data-operation as name value', function() {
        var operations = this.toolbarParser(this.html3operations);
        equal(operations.length, 3, "There should be 3 operations.");
        equal(operations[0].getName(), "operation1", "First operation should have name: operation1");
        equal(operations[1].getName(), "operation2", "Second operation should have name: operation2");
        equal(operations[2].getName(), "operation3", "Third operation should have name: operation3");
    });

    test('Parser omits skipped data-operations', function() {
        var operations = this.toolbarParser(this.html2operations);
        equal(operations.length, 2, "There should be 2 operations.");
    });

    test('Parser returns proper operation for attachments', function() {
        var operations = this.toolbarParser(this.htmlOperationsWithAttachments1);
        equal(operations.length, 3, "There should be 3 operations.");
    });

    test('Parser returns proper operation for attachments(2)', function() {
        var operations = this.toolbarParser(this.htmlOperationsWithAttachments2);
        equal(operations.length, 3, "There should be 3 operations.");
    });
});