define('jira/richeditor/wiki-adapter/selection', [

], function () {

    var windowSelectionHandler = {};
    windowSelectionHandler.saveSelection = function () {
        var s = window.getSelection();
        if (s.rangeCount > 0) {
            return window.getSelection().getRangeAt(0);
        }
    };
    windowSelectionHandler.restoreSelection = function (savedRange) {
        if (savedRange) {
            var s = window.getSelection();
            if (s.rangeCount > 0) {
                s.removeAllRanges();
            }
            s.addRange(savedRange);
        }
    };
    windowSelectionHandler.isSupported = function () {
        return window.getSelection != null;
    };

    var documentSelectionHandler = {};
    documentSelectionHandler.saveSelection = function () {
        return document.selection.createRange();
    };
    documentSelectionHandler.restoreSelection = function (savedRange) {
        if (savedRange) {
            savedRange.select();
        }
    };
    documentSelectionHandler.isSupported = function () {
        return document.selection != null;
    };

    var handlers = [windowSelectionHandler, documentSelectionHandler];

    var saveSelection = function () {
        handlers.forEach(function (handler) {
            if (handler.isSupported()) {
                handler.saveSelection();
            }
        });
    };

    var restoreSelection = function (savedRange) {
        handlers.forEach(function (handler) {
            if (handler.isSupported()) {
                handler.restoreSelection(savedRange);
            }
        });
    };

    return {save: saveSelection, restore: restoreSelection};
});

