AJS.test.require(["com.atlassian.jira.plugins.jira-editor-plugin:toggle"], function() {
    var $ = require("jquery");
    var editorToggle = require("jira/editor/toggle");
    var ToggleTabs = require("jira/editor/ui/toggle-tabs");
    var Cookie = require("jira/data/cookie");
    var featureManager = require("jira/featureflags/feature-manager");
    var skate = require("atlassian/libs/skate-0.12.6");
    var _ = require("underscore");

    module("ToggleTabs", {
        setup: function () {
            this.sandbox = sinon.sandbox.create({ });
        },

        teardown: function () {
            this.sandbox.restore();
        }
    });

    function whenElementAttached(tagName){
        var result = new $.Deferred();
        var observer = new MutationObserver(function(mutations) {
            mutations.forEach(function(mutation) {
                console.debug(mutation);
                if(mutation.type === "childList") {
                    if(mutation.addedNodes) {
                        var elements = [].slice.apply(mutation.addedNodes).filter(function(e){
                            return e.tagName === tagName;
                        });

                        if(elements.length) {
                            result.resolve(elements[0]);
                            observer.disconnect();
                        }
                    }
                }
            });
        });
        var config = { attributes: false, childList: true, characterData: false };
        observer.observe(document.querySelector("body"), config);
        return result;
    }

    test("Should show Visual tooltip on toggle", function(done) {
        this.sandbox.stub(Cookie, "read")
            .withArgs("jira.editor.user.mode").returns("source");

        verifyToggle('wysiwyg', AJS.I18n.getText('jira.editor.toggle.mode.visual'));
    });

    test("Should show Text tooltip on toggle", function(done) {
        this.sandbox.stub(Cookie, "read")
            .withArgs("jira.editor.user.mode").returns("source");

        verifyToggle('source', AJS.I18n.getText('jira.editor.toggle.mode.text'));
    });

    test("Should hide tooltip after 750ms", function(done) {
        this.sandbox.useFakeTimers();

        this.sandbox.stub(Cookie, "read")
            .withArgs("jira.editor.user.mode").returns("source");

        verifyToggle('wysiwyg', AJS.I18n.getText('jira.editor.toggle.mode.visual'));


        this.sandbox.clock.tick(800);

        ok($('#qunit-fixture').find('.editor-toggle-tooltip').is(':not(.visible)'));

    });

    var createTabs = function() {
        var $element = $('<div class="wiki-edit-content" style="position: fixed; left: 100px; top: 100px"><textarea> </textarea></div>').appendTo('#qunit-fixture').find('textarea');
        return new ToggleTabs($element[0]);
    };

    var verifyToggle = function(mode, expectedText) {
        var tabs = createTabs();

        var $tooltip = tabs.$parent.find('.editor-toggle-tooltip');

        tabs.$parent.find('*[data-mode="' + mode + '"] a').click();

        ok($tooltip.is('.visible'));
        equal($tooltip.text(), expectedText);
    }

});