/* eslint-disable max-len */
AJS.test.require([
    'com.atlassian.jira.plugins.jira-editor-plugin:converter',
    'com.atlassian.jira.plugins.jira-editor-plugin:mentions'
], function () {
    "use strict";

    module('Mentions', {
        setup: function () {
            this.context = AJS.test.mockableModuleContext();
            this.sandbox = sinon.sandbox.create();

            this.MentionRte = this.context.require('jira/editor/plugins/mentions/mention-rte');
        },

        teardown: function () {
            this.sandbox.restore();
        }
    });

    test('Username and displayname is escaped when rendering link', function () {
        var xss = "XSS'\"<script>alert(1)</script>";
        var renderedEscaped =
            "<a href=\"" + AJS.contextPath() + "/secure/ViewProfile.jspa?name=XSS%27%22%3Cscript%3Ealert%281%29%3C%2Fscript%3E\" class=\"user-hover\" rel=\"XSS&#39;&quot;&lt;script&gt;alert(1)&lt;/script&gt;\" title=\"jira.editor.tags.follow.link\">Displayname XSS&#39;&quot;&lt;script&gt;alert(1)&lt;/script&gt;</a>";

        var mentionRte = new this.MentionRte();
        var rendered = mentionRte._renderMentionLink(xss, "Displayname "+xss);

        equal(rendered, renderedEscaped);
    });
});