define("jira/editor/height-helper", [
    "jquery",
    "jira/editor/height-helper-heights"
], function (
    $,
    Heights
) {
    var HeightHelper = function (element) {
        this.element = element;

        /**
         * MNSTR-129
         * Textarea fields on full issue details page (inline edit): 300px
         * Textarea fields on issue details on board/backlog in the sidebar: 300px
         * Textarea fields in dialogs: 255px
         * Comment section: 255px
         * @returns {number}
         */
        this.getMinHeight = function () {
            return this._getLocation().min;
        };

        /**
         * Textarea fields on full issue details page (inline edit): 710px
         * Textarea fields on issue details on board/backlog in the sidebar: 710px
         * Textarea fields in dialogs: 450px
         * Comment section: 710px
         * @returns {number}
         */
        this.getMaxHeight = function () {
            return this._getLocation().max;
        };

        this.setHeights = function (element, offset) {
            var offset = offset || 0;
            var $el = element ? $(element) : $(this.element);
            $el.css('height', '');
            $el.removeAttr('rows');
            var location = this._getLocation();
            $el.css('min-height', (location.min + offset) + 'px');
            $el.css('max-height', (location.max + offset) + 'px');
        };

        this._getLocation = function () {
            if (this._isDialog()) {
                return Heights.DIALOG_ISSUE_DETAILS;
            } else if (this._isBoard()) {
                return Heights.BOARD_BACKLOG_ISSUE_DETAILS;
            } else if (this._isComment()) {
                return Heights.COMMENT;
            } else if (this._isSDComment()) {
                return Heights.SD_COMMENT;
            } else {
                return Heights.FULL_ISSUE_DETAILS;
            }
        };

        this._isComment = function () {
            return $(this.element).closest('.comment-input').length > 0;
        };

        this._isSDComment = function () {
            return $(this.element).closest('sd-comment').length > 0;
        };

        this._isDialog = function () {
            return $(this.element).closest('.jira-dialog').length > 0
        };

        this._isBoard = function () {
            return $(this.element).closest('.ghx-detail-view').length > 0
        };
    };

    return HeightHelper;
});
