define('jira/editor/fsm/states/state', [
    'underscore'
], function(
    _
) {
    var baseDecorator = function(name, handler) {
        handler.stateName = name;
        handler.extend = extend;

        return handler;
    };

    var extend = function(fn) {
        return baseDecorator(this.stateName, _.compose(fn, this));
    };

    return function(name, handler) {
        return baseDecorator(name, handler);
    };
});
