define('jira/editor/fsm/states/mode-visual', [
    'jira/editor/fsm/states/state',
    'jira/editor/fsm/states/detached',
    'jira/editor/fsm/events',
    'jira/editor/analytics',
    'jira/editor/constants'
], function(
    State,
    StateDetached,
    Events,
    Analytics,
    Constants
) {
    return function(element) {
        var StateText = require('jira/editor/fsm/states/mode-text');

        var ts = window.performance.now();
        return State("Visual", function Visual(eventType, eventObject) {
            if (eventType === Events.DETACHED && eventObject === element) {
                return StateDetached(element);
            }

            if (eventType === Events.TABS_CHANGE && eventObject === Constants.Modes.TEXT) {
                return StateText(element);
            }
        }).extend(function(nextState) {
            if (nextState) {
                Analytics.sendEvent("editor.instance.tab.timing.visual", {time: window.performance.now() - ts});
            }

            return nextState;
        });
    };
});
