define('jira/editor/fsm/states/attached', [
    'jira/editor/fsm/states/state',
    'jira/editor/fsm/states/wrap',
    'jira/editor/fsm/events',
    'jquery'
], function(
    State,
    StateWrap,
    Events,
    $
) {
    return function(element) {
        var StateInit = require('jira/editor/fsm/states/init');

        // get textarea with wiki for this element
        var $element = $(element);
        if (!$element.parent().hasClass("rte-container")) {
            $element.wrap(JIRA.Editor.Init.Templates.container());
        }
        var textarea = $element.parent().siblings('textarea[class*="wiki-textfield"]')[0];
        if (textarea) {
            // wiki editor may load asynchronous - it does not initialize when it's invisible
            // it may however be on the other tab - and it's invisible then
            if (!textarea.wikiEnabled) {
                $(textarea).one("wiki-editor-initialized", function () {
                    element.FSM.triggerEvent(Events.WIKI_EDITOR_INITIALIZED);
                }.bind(this));
            } else {
                return StateWrap(element, textarea);
            }
        }

        return State("Attached", function (eventType, eventObject) {
            if (eventType === Events.DETACHED) {
                return StateInit(eventObject);
            }

            if (eventType === Events.WIKI_EDITOR_INITIALIZED || /* corner case for comment box */ eventType === Events.ATTACHED) {
                if ($(textarea).is(":visible")) {
                    return StateWrap(element, textarea);
                }
            }
        });
    };
});
