define('jira/editor/fsm', [
    'jira/editor/fsm/states/init',
    'jira/editor/fsm/events',
    'jira/lib/class',
    'jira/util/logger',
    "underscore"
], function(
    StateInit,
    Events,
    Class,
    logger,
    _
) {
    var FSM = Class.extend({
        init: function() {
            this.currentState = StateInit();
        },

        triggerEvent: function (event) {
            logger.debug("JEP FSM - Event:", event, _.rest(arguments, 1));
            logger.debug("JEP FSM - Current state:", this.currentState.stateName);

            var nextState = this.currentState.apply(null, arguments);
            if (_.isFunction(nextState) && nextState !== this.currentState) {
                this.currentState = nextState;
                logger.debug("JEP FSM - Next State:", nextState.stateName);
            }
        }
    });

    FSM.Events = Events;

    return FSM;
});
