AJS.test.require([
    'com.atlassian.jira.plugins.jira-editor-plugin:registry',
    'com.atlassian.jira.plugins.jira-editor-plugin:fsm'
], function () {
    var Constants = require('jira/editor/constants');
    var Events = require('jira/editor/fsm/events');

    var Analytics = require('jira/editor/analytics');
    var FSM = require('jira/editor/fsm');
    var StateText = require('jira/editor/fsm/states/mode-text');
    var StateVisual = require('jira/editor/fsm/states/mode-visual');

    module('ContextDetector "pre"', {
        setup: function () {
            this.sandbox = sinon.sandbox.create();

            this.sendEvent = this.sandbox.stub(Analytics, "sendEvent");

            this.fsm = new FSM();
        },

        teardown: function () {
            this.sandbox.restore();
        }
    });

    test('Should send event on transition between modes', function () {
        var now = 0;
        this.sandbox.stub(window.performance, "now", function() {
            return now;
        });

        var element = document.createElement('rich-editor');
        var state = StateText(this.fsm, element);
        now += 1000;
        state = state(Events.TABS_CHANGE, Constants.Modes.VISUAL);
        equal(state.stateName, 'Visual', 'Transitioned to Visual');
        equal(this.sendEvent.getCalls().map(function(call) { return call.args[0] + " - " + call.args[1].time; }).join("\n"), "editor.instance.tab.timing.text - 1000");

        now += 2000;
        state = state(Events.TABS_CHANGE, Constants.Modes.TEXT);
        equal(state.stateName, 'Text', 'Transitioned to Text');
        equal(this.sendEvent.getCalls().map(function(call) { return call.args[0] + " - " + call.args[1].time; }).join("\n"),
            ["editor.instance.tab.timing.text - 1000", "editor.instance.tab.timing.visual - 2000"].join("\n"));
    });
});