define("jira/editor/undo-redo-analytics", [
    "jira/editor/analytics",
    "jira/editor/constants",
    "jira/lib/class"
], function (
    Analytics,
    EditorConstants,
    Class
) {
    "use strict";

    var UndoRedoAnalytics = Class.extend({
        init: function init(UndoManager) {
            UndoManager.on("editor:historychanged", function handleHistoryChange(eventName, source, mode) {
                if (EditorConstants.EventTypes.UNDO === eventName) {
                    this.logUndo(eventName, source, mode);
                } else if (EditorConstants.EventTypes.REDO === eventName) {
                    this.logRedo(eventName, source, mode);
                }

                // ignore first ADD event, everything else changes `isFirstEditorAction` to false
                if (EditorConstants.EventTypes.ADD === eventName) {
                    if (this.countAddEvents > 0) {
                        this.isFirstEditorAction = false;
                    }
                    ++this.countAddEvents;
                } else {
                    this.isFirstEditorAction = false;
                }
            }, this);
        },
        logUndo: function logUndo(eventName, source, mode) {
            Analytics.sendEvent("editor.instance.action." + eventName, {
                firstAction: this.isFirstEditorAction,
                source: source,
                mode: mode
            });
            Analytics.sendEvent("editor.instance.action", {name: eventName, mode: mode});
        },
        logRedo: function logRedo(eventName, source, mode) {
            Analytics.sendEvent("editor.instance.action." + eventName, {
                source: source,
                mode: mode
            });
            Analytics.sendEvent("editor.instance.action", {name: eventName, mode: mode});
        },
        clearCounters: function clearCounters() {
            this.isFirstEditorAction = true;
            this.countAddEvents = 0;
        },
        countAddEvents: 0,
        isFirstEditorAction: true
    });

    return UndoRedoAnalytics;
});