AJS.test.require(["com.atlassian.jira.plugins.jira-editor-plugin:api"], function() {
    "use strict";

    var SupportedOperations = require("jira/richeditor/editor-supported-operations");

    module("EditorSupportedOperations", {
        setup: function () {

        },

        teardown: function () {
        }
    });

    test("Should work in case of empty arrays", function(assert) {
        var operations = [];
        var extraTags = [];
        var expectations = [];

        assertMapping(operations, extraTags, expectations);
    });

    test("Should add extra tags", function(assert) {
        var operations = [];
        var extraTags = ["div", "a"];
        var expectations = ["a", "div"];

        assertMapping(operations, extraTags, expectations);
    });

    test("Should map operation to tags", function(assert) {
        var operations = ["italic"];
        var extraTags = [];
        var expectations = ["em", "i"];

        assertMapping(operations, extraTags, expectations);
    });

    test("Should map operations to tags", function(assert) {
        var operations = ["italic", "noformat"];
        var extraTags = [];
        var expectations = ["em", "i", "pre"];

        assertMapping(operations, extraTags, expectations);
    });

    test("Should do not map empty operations", function(assert) {
        var operations = ["paragraph"];
        var extraTags = [];
        var expectations = [];

        assertMapping(operations, extraTags, expectations);
    });

    test("Should pass 1-1 operation", function(assert) {
        var operations = ["h3"];
        var extraTags = [];
        var expectations = ["h3"];

        assertMapping(operations, extraTags, expectations);
    });

    test("Should do not produce duplicates", function(assert) {
        var operations = ["bullet-list", "numbered-list"];
        var extraTags = ["li"];
        var expectations = ["ol", "ul", "li"];

        assertMapping(operations, extraTags, expectations);
    });

    test("Should concat mapped operations and extra tags", function(assert) {
        var operations = ["bullet-list", "numbered-list", "bold", "icon", "h1"];
        var extraTags = ["a", "cite"];
        var expectations = ["ol", "ul", "li", "b", "strong", "img", "a", "cite", "h1"];

        assertMapping(operations, extraTags, expectations);
    });


    function assertMapping(operations, extraTags, expectations) {
        deepEqual(
            SupportedOperations.mapWikiOperationToHtmlTags(operations, extraTags).sort(),
            expectations.sort()
        );
    }
});