AJS.test.require(["com.atlassian.jira.plugins.jira-editor-plugin:schema"],function(){QUnit.config.testTimeout=5000;var b=require("underscore");var e=require("jira/editor/schema");var a=["onload","onerror","onmouseover","onmouseout","onfocus","onclick","ondblclick","ondrag","onmousedown","onmousemove","onmouseup","onmousewheel","oncopy","onpaste","oncut"];module("EditorSchema - default schema",{setup:function(){this.schema=e.getSchemaFromSpec(e.getSchemaSpecBuilder().build())}});c();test("Should allow contenteditable attribute",function(f){f.ok(d("div",["contenteditable"],this.schema))});module("EditorSchema - paste schema",{setup:function(){this.schema=e.getSchemaFromSpec(e.getPasteSchemaSpecBuilder().build())}});c();test("Should not allow contenteditable attribute",function(f){f.ok(!d("div",["contenteditable"],this.schema))});module("EditorSchema - schema for pre",{setup:function(){this.schema=e.getSchemaFromSpec(e.getPasteInsidePreSchemaSpecBuilder().build())}});test("Should allow some tags but without 'style' attribute",function(){var f=["br","span","p"];f.forEach(function(g){ok(this.schema.isValid(g),"Should allow '"+g+"' tag");ok(!d(g,["style"],this.schema),"Should not allow 'style' attribute for "+g)}.bind(this));ok(this.schema.isValidChild("span","#text"),"'#text' node should be allowed inside <span>");ok(this.schema.isValidChild("p","#text"),"'#text' node should be allowed inside <p>")});test("Should not allow unsupported tags",function(f){var g=["div","panel-title","table","b","strong","sup","sub","img","tt","code","del","cite","h1","applet","basefont","audio","canvas","command","dialog","embed","iframe","noframes","script","noscript","object","picture","summary","time","video","wbr"];g.forEach(function(h){f.ok(!this.schema.isValid(h),"Should not allow '"+h+"' tag")}.bind(this))});function c(){test("Schema should be created",function(f){f.ok(this.schema)});test("Should not allow explicit <body>",function(f){f.ok(!this.schema.isValid("body"),"body element");f.ok(!d("body",[],this.schema),"body without attributes");f.ok(!d("body",["onload"],this.schema),"body with onload attribute")});test("Should not allow <a> with event handlers",function(f){a.forEach(function(g){f.ok(!this.schema.isValid("a",g),g)}.bind(this))});test("Should allow <a> with attributes",function(f){f.ok(d("a",["href","title","target","rel","name"],this.schema))});test("Should not allow <img> with event handlers",function(f){a.forEach(function(g){f.ok(!this.schema.isValid("img",g),g)}.bind(this))});test("Should not allow <img> without attributes",function(f){f.ok(!d("img",[],this.schema))});test("Should allow <img> with src specified",function(f){f.ok(d("img",["src"],this.schema))});test("Should allow <img> with attributes",function(f){f.ok(d("img",["src","class","height","width","align","alt","border"],this.schema))});test("Should allow <img> inside <span>",function(f){f.ok(this.schema.isValidChild("span","img"))});test("Should allow headings",function(f){var g=["h1","h2","h3","h4","h5","h6"];g.forEach(function(h){f.ok(this.schema.isValid(h),"Should allow '"+h+"' tag")}.bind(this))});test("Should not allow unsupported tags",function(f){var g=["applet","basefont","audio","canvas","command","dialog","embed","iframe","noframes","script","noscript","object","picture","summary","time","video","wbr"];g.forEach(function(h){f.ok(!this.schema.isValid(h),"Should not allow '"+h+"' tag")}.bind(this))});test("Should allow tables",function(f){f.ok(d("table",["class"],this.schema));f.ok(d("td",["class"],this.schema))});test("Should not allow nested tables",function(f){f.ok(!this.schema.isValidChild("td","table"));f.ok(!this.schema.isValidChild("th","table"))});test("Should not allow paragraph inside table cells",function(f){f.ok(!this.schema.isValidChild("td","p"));f.ok(!this.schema.isValidChild("th","p"))});test("Should allow panels",function(f){f.ok(d("div",["class","style"],this.schema));f.ok(d("div",["class"],this.schema));f.ok(d("div",[],this.schema))});test("Should not allow forms",function(f){["form","input","select"].forEach(function(g){f.ok(!this.schema.isValid(g),g)}.bind(this))});test("Should support custom element",function(f){var g="panel-title";ok(this.schema.isValid(g),g);ok(this.schema.isValidChild(g,"#text"));ok(this.schema.isValidChild(g,"span"));["h2","b","strong","p","div","u","em","table","img","br"].forEach(function(h){f.ok(!this.schema.isValidChild(g,h),"Should not allow '"+h+"' inside <"+g+">")}.bind(this))});test("Should allow only new lines, span and #text in <pre>",function(f){ok(this.schema.isValidChild("pre","br"),"Should allow <br> inside <pre>");ok(this.schema.isValidChild("pre","#text"),"Should allow #text inside <pre>");ok(this.schema.isValidChild("pre","span"),"Should allow <span> inside <pre>");ok(this.schema.isValidChild("pre","pre"),"Should allow <pre> inside <pre>");ok(this.schema.isValidChild("pre","panel-title"),"Should allow <panel-title> inside <pre>");["h2","b","strong","div","ins","u","em","i","table","img"].forEach(function(g){f.ok(!this.schema.isValidChild("pre",g),"Should not allow '"+g+"' inside <pre>")}.bind(this))})}function d(g,f,h){if(!h.isValid(g)){return false}var i=h.getElementRule(g);return(0===b.difference(f,Object.keys(i.attributes)).length&&0===b.difference(i.attributesRequired,f).length)}});