define("jira/editor/instance",["jira/editor/analytics","jira/editor/analytics-shortcuts","jira/util/navigator","jira/editor/tinymce","jira/editor/context-manager","jira/editor/context-detector","jira/editor/schema","jira/editor/selection","jquery","backbone","underscore"],function(g,e,l,j,k,f,c,d,b,i,h){var a=function(n,m){this.element=n;this.options=h.extend({},m)};h.extend(a.prototype,i.Events);a.prototype.init=function(n){this.editor=n;this.operationSelectedListeners={};this.operationSelectedState={};this.operationOverride={};this.analyticsShortcuts=new e(this.editor);this.selection=new d(this.editor);this.editor.on("NodeChange",function(s){var q=g.startMeasure();Object.keys(this.operationSelectedListeners).forEach(function(u){var t=this.operationSelectedState[u];var v=this._getOperationState(u);if(v!==t){this.operationSelectedListeners[u].forEach(function(w){w(v)})}}.bind(this));if(!s){return}if(s.element.nodeName.toLowerCase()==="img"){this.editor.fire("content")}var p=g.startMeasure();var r=b(s.element);this.trigger("selection:update",{insidePreformatted:f.detectPre(r),preformattedSelected:f.detectPreWithinSelection(this.editor.selection.getContent()),insideTable:f.detectTable(r),insideA:f.detectA(r)});p.measure("nodechange.context-detection");q.measure("nodechange")}.bind(this));this.editor.on("change SetContent blur",this._onChange.bind(this));this.editor.on("keyup",h.debounce(this._onChange.bind(this),1000));this.editor.on("init",function(t){var r=t.target;["tt","del","sup","sub","cite"].forEach(function(u){r.formatter.register(u,{block:u,remove:"all"})});var q=["meta+b","meta+i","meta+u"];for(var p=1;p<=9;p++){q.push("access+"+p)}var s=function(){};q.forEach(function(u){r.addShortcut(u,"deleted_shortcut",s)})});n.on("keydown",function(p){if(p.isDefaultPrevented()){return}var q=b(n.selection.getStart());if(p.keyCode===j.util.VK.ENTER&&!p.shiftKey&&q.is("td > p, th > p, th > br, td > br, td, th")){p.preventDefault();n.execCommand("InsertLineBreak",false,p)}if(p.keyCode===j.util.VK.ENTER&&(q.is("panel-title, panel-title *")||q.parent().hasClass("panelHeader"))){p.preventDefault()}});var m=function(){if((/(Edge)\/(\d+)\.(\d+)/).test(l._getUserAgent())){return"edge"}else{if(l.isIE()){return"ie"}else{if(l.isChrome()){return"chrome"}else{if(l.isMozilla()){return"firefox"}else{if(l.isSafari()){return"safari"}}}}}return""};g.sendEvent("editor.instance.init");g.sendEvent("bundled.editor.instance.init");var o=m();if(o){g.sendEvent("editor.instance.init."+o)}this.contextManager=new k(this);n.contextManager=this.contextManager};a.prototype.getId=function(){return this.editor.id};a.prototype.relayEvent=function(n,o,m){this.editor.on(n,function(p){o(p)},m)};a.prototype.getAllowedOperations=function(){return["paragraph","h1","h2","h3","h4","h5","h6","monospace","paragraph-quote","block-quote","delete","superscript","subscript","cite",{name:"icon",values:[":)",":(",":P",":D",";)","(y)","(n)","(i)","(/)","(x)","(!)","(+)","(-)","(?)","(on)","(off)","(*)","(*r)","(*g)","(*b)","(*y)"]},"bold","italic","underline","color","bullet-list","numbered-list","mention","table","code","noformat","panel","hr","speech","link","link-mail","link-anchor","link-attachment","image","image-attachment","attachment","editorInsertContent","editorInsertContentInNewLine","editorReplaceContent","editorReplaceContentInNewLine"]};a.prototype._isOperationSupported=function(m){var n=this.getAllowedOperations().filter(function(o){if(o instanceof Object){return o.name===m}else{return o===m}});return n.length>0};a.prototype._assertOperationIsSupported=function(m){if(!this._isOperationSupported(m)){console.error("Operation not supported:",m)}};a.prototype._selectedTextSanitized=function(){return c.sanitizeHtml(this.editor.selection.getContent(),this.editor,this.pasteInsidePreSchemaSpec)};a.prototype.executeOperation=function(m,p){this._assertOperationIsSupported(m);var o=this._mapOperationNameToTinymce(m);var n=this.operationOverride[m];if(n){g.sendEvent("editor.instance.operation."+m);n(p);return true}if("editorReplaceContentInNewLine"===m){this.editor.execCommand("mceReplaceContent",false,"<br />"+p.content)}else{if("editorReplaceContent"===m){this.editor.execCommand("mceReplaceContent",false,p.content)}else{if("editorInsertContentInNewLine"===m){this.editor.insertContent("<br />"+p.content)}else{if("editorInsertContent"===m){this.editor.insertContent(p.content)}else{if("hr"===m){this.editor.insertContent("<hr />")}else{if("color"===m){this.editor.execCommand("ForeColor",true,p.color)}else{if(["h1","h2","h3","h4","h5","h6","paragraph","paragraph-quote","block-quote","monospace","cite"].indexOf(m)>-1){this.editor.execCommand("mceToggleFormat",true,o)}else{if(["bold","italic","underline","delete","superscript","subscript"].indexOf(m)>-1){if(this.selection.trimSelection()){if(!this.selection.hasSelection()){g.sendEvent("editor.instance.selection.collapsed",{op:m});return false}else{g.sendEvent("editor.instance.selection.trimmed",{op:m})}}this.editor.execCommand(o,true)}else{if(["bullet-list","numbered-list"].indexOf(m)>-1){this.editor.execCommand(o,true)}else{if("icon"===m){var s;if(AJS&&AJS.contextPath){s=AJS.contextPath()}else{s=""}var r=s+"/images/icons/emoticons/"+this._emoticonSourceMap(p.icon);this.editor.insertContent('<img class="emoticon" src="'+r+'" height="16" width="16" align="absmiddle" alt="" border="0">')}else{if("attachment"===m&&p.attachment){this.editor.insertContent(p.attachment)}else{if("code"===m){var q=(this._selectedTextSanitized()||AJS.I18n.getText("jira.editor.macro.code.placeholder")+"\n");this.editor.selection.setContent('<pre class="code panel" data-language="code-java">'+q+"</pre>")}else{if("panel"===m){var q=(this.editor.selection.getContent()||AJS.I18n.getText("jira.wiki.editor.operation.panel.placeholder"));this.editor.selection.setContent('<div class="plain panel" style="border-width: 1px;"><panel-title>'+AJS.I18n.getText("jira.wiki.editor.operation.panel.placeholder.title")+"</panel-title><p>"+q+"</p></div>")}else{if("noformat"===m){var q=(this._selectedTextSanitized()||AJS.I18n.getText("jira.wiki.editor.operation.noFormat.placeholder"));this.editor.selection.setContent('<pre class="noformat panel">'+q+"</pre>")}else{if("table"===m){var q=(this.editor.selection.getContent()||(AJS.I18n.getText("jira.wiki.editor.operation.table.placeholder.column")+" A1"));this.editor.selection.setContent('<div class="table-wrap"><table class="confluenceTable mce-item-table" data-mce-selected="1"><tbody><tr><th class="confluenceTh">'+AJS.I18n.getText("jira.wiki.editor.operation.table.placeholder.heading")+' 1</th><th class="confluenceTh">'+AJS.I18n.getText("jira.wiki.editor.operation.table.placeholder.heading")+' 2</th></tr><tr><td class="confluenceTd">'+q+'</td><td class="confluenceTd">Col A2</td></tr></tbody></table></div>');g.sendEvent("editor.instance.table.toolbar")}else{if(["mention","speech","link","link-mail","link-anchor","link-attachment","image","image-attachment"].indexOf(m)>-1){console.warn("Not supported yet "+m);return false}else{console.warn("Unsupported operation "+m);return false}}}}}}}}}}}}}}}}g.sendEvent("editor.instance.operation."+m);this.trigger("content");return true};a.prototype.bindOperationSelectedListener=function(m,o){var n=this.operationSelectedListeners[m]||[];n.push(o);this.operationSelectedListeners[m]=n};a.prototype.unbindOperationSelectedListener=function(m,p){var n=this.operationSelectedListeners[m]||[];var o=n.indexOf(p);if(o>-1){n.splice(o,1)}};a.prototype._getOperationState=function(m){return this.editor.queryCommandState(this._mapOperationNameToTinymce(m))};a.prototype._mapOperationNameToTinymce=function(m){var n={bold:"Bold",italic:"Italic",underline:"Underline","bullet-list":"InsertUnorderedList","numbered-list":"InsertOrderedList",blockquote:"mceBlockQuote",paragraph:"p","paragraph-quote":"blockquote","block-quote":"blockquote",monospace:"tt","delete":"strikethrough",superscript:"superscript",subscript:"subscript"};if(m in n){return n[m]}return m};a.prototype._emoticonSourceMap=function(n){var m={":)":"smile.png",":(":"sad.png",":P":"tongue.png",":D":"biggrin.png",";)":"wink.png","(y)":"thumbs_up.png","(n)":"thumbs_down.png","(i)":"information.png","(/)":"check.png","(x)":"error.png","(!)":"warning.png","(+)":"add.png","(-)":"forbidden.png","(?)":"help_16.png","(on)":"lightbulb_on.png","(off)":"lightbulb.png","(*)":"star_yellow.png","(*r)":"star_red.png","(*g)":"star_green.png","(*b)":"star_blue.png","(*y)":"star_yellow.png","(flag)":"flag.png","(flagoff)":"flag_grey.png"};if(n in m){return m[n]}return n};a.prototype.focus=function(){this.editor.focus()};a.prototype.destroy=function(){this.editor.contextManager=null;this.editor.remove();g.sendEvent("editor.instance.destroy");g.sendEvent("bundled.editor.instance.destroy")};a.prototype.setContent=function(p,o,m){var n={};if(o){n={format:"raw"}}n.no_events=m;this.editor.setContent(p,n);this.lastContent=this.getContent();if(!m){this.trigger("content")}};a.prototype.replaceSelection=function(m){this.editor.selection.setContent(m);this.trigger("content")};a.prototype.selectAll=function(){this.editor.selection.select(this.editor.getBody(),true)};a.prototype.getContent=function(n){var m={};if(n){m={format:"raw"}}return this.editor.getContent(m)};a.prototype._onChange=function(){if(this.editor.destroyed){return}var m=this.getContent();var n=m!==this.lastContent;this.lastContent=m;if(!this.hidden&&n){this.trigger("content",this.getContent())}};a.prototype.getSelectedContent=function(m){if(m){return this.editor.selection.getContent({format:"text"})}else{return this.editor.selection.getContent()}};a.prototype.addShortcut=function(m,n){this.editor.addShortcut(m,"",n)};a.prototype.removeShortcut=function(m){this.editor.shortcuts.remove(m)};a.prototype.addOperationOverride=function(m,n){this._assertOperationIsSupported(m);this.operationOverride[m]=n};a.prototype.removeOperationOverride=function(m){this._assertOperationIsSupported(m);delete this.operationOverrideoperationOverride[m]};a.prototype.hide=function(){this.hidden=true;this.editor.hide()};a.prototype.show=function(){this.editor.show();delete this.hidden};a.prototype.isVisible=function(){return !this.editor.isHidden()};a.prototype.switchMode=function(m){this.trigger("switchMode",m)};a.prototype.enable=function(){this.editor.setProgressState(false)};a.prototype.disable=function(){this.editor.setProgressState(true)};return a});