define("jira/editor/html-renderer", [
    "wrm/context-path",
    "jquery",
    "underscore"
], function (
    wrmContextPath,
    $,
    _
) {
    "use strict";

    var renderMarkup = function (markup, dataParams) {
        dataParams = dataParams || {};

        var data = _.extend({
            rendererType: "atlassian-wiki-renderer",
            unrenderedMarkup: markup,
            forWysiwyg: true
        }, dataParams);

        return $.ajax({
            url: wrmContextPath() + "/rest/api/1.0/render",
            contentType: "application/json",
            type: 'POST',
            data: JSON.stringify(data),
            dataType: "html"
        });
    };

    return {
        renderMarkup: renderMarkup
    };
});