define("jira/editor/converter/handlers/subscript-handler", [
    "jira/editor/converter/handlers/node-handler",
    "jira/editor/converter/handlers/text-handler",
    "jira/editor/converter/factories/whitespace-extractor"
], function (
    NodeHandler,
    TextHandler,
    WhitespaceExtractor
) {
    "use strict";

    /**
     * @class SubscriptHandler
     * @extends NodeHandler
     */
    var handler = NodeHandler.extend({
        init: function SubscriptHandler(node) {
            this.node = node;
        },

        before: function () {
            return TextHandler.createTextHandler('~');
        },

        after: function () {
            return TextHandler.createTextHandler('~');
        }
    });
    return WhitespaceExtractor(handler);
});