define("jira/editor/converter/handlers/strikethrough-handler", [
    "jira/editor/converter/handlers/node-handler",
    "jira/editor/converter/handlers/text-handler",
    "jira/editor/converter/handlers/link-handler",
    "jira/editor/converter/handlers/empty-handler",
    "jira/editor/converter/factories/whitespace-extractor",
    "jquery"
], function (
    NodeHandler,
    TextHandler,
    LinkHandler,
    EmptyHandler,
    WhitespaceExtractor,
    $
) {
    "use strict";

    /**
     * @class StrikethroughHandler
     * @extends NodeHandler
     */
    var handler = NodeHandler.extend({
        init: function StrikethroughHandler(node) {
            this.node = node;

            if ($(node.parentNode).is('a[data-issue-key]')) {
                this.isIssue = LinkHandler.isIssue($(node.parentNode).attr("href"));
            }
        },

        before: function () {
            return this.isIssue ? new EmptyHandler() : TextHandler.createTextHandler('-');
        },

        after: function () {
            return this.isIssue ? new EmptyHandler() : TextHandler.createTextHandler('-');
        }
    });
    return WhitespaceExtractor(handler);
});