define("jira/editor/converter/handlers/list-type-matcher", [
    "jquery",
    "underscore"
], function (
    jQuery,
    _
) {
    "use strict";

    /**
     * @class ListTypeMatcher
     * @extends NodeHandler
     */
    var ListTypeMatcher = {};

    ListTypeMatcher.selectorBulletMap = {};
    ListTypeMatcher.selectorBulletMap['ul:not(.alternate)'] = '*';
    ListTypeMatcher.selectorBulletMap['ul.alternate'] = '-';
    ListTypeMatcher.selectorBulletMap['ol'] = '#';

    ListTypeMatcher.DEFAULT_DECORATOR = '*';

    /**
     * Looks for a bullet decorator in the selectorBulletMap.
     * @param node document node
     * @returns bullet decorator string or null if not found
     */
    ListTypeMatcher.matchBullet = function (node) {
        return _.find(ListTypeMatcher.selectorBulletMap, function (value, key) {
            return jQuery(node).is(key);
        });
    };

    ListTypeMatcher.getBulletDecorator = function (node) {
        return ListTypeMatcher.matchBullet(node) || ListTypeMatcher.DEFAULT_DECORATOR;
    };

    ListTypeMatcher.isListNode = function (node) {
        return ListTypeMatcher.matchBullet(node) != null;
    };

    return ListTypeMatcher;
});