define("jira/editor/converter/factories/right-trim", [
    "jira/editor/constants"
], function (
    Constants
) {
    "use strict";

    /**
     * Takes object/instance or constructor of a handler as parameter and:
     * 1) trims the content from the right, if any
     * 2) wrap the last child node into RightTrim in order to apply the logic for the child (till text node)
     *
     * @param {Function|Object} BaseHandler works for both, constructor and instance
     */
    return function handlerFactory(BaseHandler) {
        var RightTrim = Object.create(BaseHandler);
        RightTrim.createChildHandler = function createChildHandler(childNode, childIndex, childrenTotal) {
            var handler = Object.getPrototypeOf(RightTrim).createChildHandler.call(this, childNode, childIndex, childrenTotal);
            if (childrenTotal - 1 === childIndex) {
                handler = handlerFactory(handler);
            }
            return handler;
        };
        RightTrim.processText = function processText() {
            return Object.getPrototypeOf(RightTrim).processText.call(this)
                .replace(Constants.RIGHT_WHITESPACE_MATCHER, "");
        };
        RightTrim._extractRightSpaces = function () {};

        return RightTrim;
    };
});