AJS.test.require(["com.atlassian.jira.plugins.jira-editor-plugin:constants","com.atlassian.jira.plugins.jira-editor-plugin:api","com.atlassian.jira.plugins.jira-editor-plugin:registry"],function(){var a=require("jira/editor/registry/entry");var b=require("jira/editor/constants").Modes;var e=require("jira/editor/instance");var d=require("jira/editor/registry");module("EditorRegistry",{getExpectedEntry:function(f){return{id:this.id,toolbar:this.toolbar,textArea:this.textArea,currentMode:f}},setup:function(){this.sandbox=sinon.sandbox.create();this.textArea=this.sandbox.mock();this.toolbar=this.sandbox.mock();this.id=Date.now().toString();this.sandbox.stub(a.prototype,"_findToolbar").returns(this.toolbar);this.sandbox.stub(d,"_findTextArea").returns(this.textArea);this.sandbox.stub(d,"_getTextAreaId").returns(this.id);this.sandbox.spy(d,"_triggerEvents")},teardown:function(){this.sandbox.restore();d._instances={}}});test("Should trigger `register` events on Text mode activation",function(){d._registerTextMode(this.textArea);var f=this.getExpectedEntry(b.TEXT);var g=d._triggerEvents;ok(g.calledOnce,"_triggerEvents called once");ok(g.firstCall.calledWithMatch(sinon.match("register"),c(f)),"_triggerEvents called with correct arguments")});test("Should trigger `register` events on Visual mode activation",function(g){var h=new e();d._registerVisualMode(h);var f=this.getExpectedEntry(b.VISUAL);var i=d._triggerEvents;ok(i.calledOnce,"_triggerEvents called once");ok(i.firstCall.calledWithMatch(sinon.match("register"),c(f)),"_triggerEvents called with correct arguments")});test("Should register correct entry in Text mode",function(){d._registerTextMode(this.textArea);var f=this.getExpectedEntry(b.TEXT);var g=d.getEntry(this.id);ok(sinon.match(g,c(f)),"editorRegistry contains correct entry")});asyncTest("Should register correct entry in Visual mode",function(){var g=new e();d._registerVisualMode(g);var f=this.getExpectedEntry(b.VISUAL);var h=d.getEntry(this.id);ok(sinon.match(h,c(f)),"editorRegistry contains correct entry");h.rteInstance.done(function(i){start();strictEqual(i,g,"Entry has correctly resolved rteInstance")})});test("Should trigger `unregister` events upon unregistration in Text mode",function(){d._registerTextMode(this.textArea);d._unregister(this.textArea);var f=this.getExpectedEntry(b.TEXT);var g=d._triggerEvents;ok(g.calledTwice,"_triggerEvents called twice");ok(g.secondCall.calledWithMatch(sinon.match("unregister"),c(f)),"_triggerEvents called with correct arguments")});test("Should trigger `unregister` events upon unregistration in Visual mode",function(){d._registerVisualMode(new e());d._unregister(this.textArea);var f=this.getExpectedEntry(b.VISUAL);var g=d._triggerEvents;ok(g.calledTwice,"_triggerEvents called twice");ok(g.secondCall.calledWithMatch(sinon.match("unregister"),c(f)),"_triggerEvents called with correct arguments")});test("Should trigger `unregister` events upon unregistration after switching modes",function(){d._registerTextMode(this.textArea);d._registerVisualMode(new e());d._switchMode(this.textArea,b.TEXT);d._unregister(this.textArea);var f=this.getExpectedEntry(b.TEXT);var g=d._triggerEvents;equal(g.callCount,4,"_triggerEvents called 4 times");ok(g.lastCall.calledWithMatch(sinon.match("unregister"),c(f)),"_triggerEvents called with correct arguments")});test("Should remove entry correctly upon unregistration in Text mode",function(){d._registerTextMode(this.textArea);d._unregister(this.textArea);var f=d.getEntry(this.id);strictEqual(f,undefined,"editorRegistry has entry removed after `unregister` event")});test("Should remove entry correctly upon unregistration in Visual mode",function(){d._registerVisualMode(new e());d._unregister(this.textArea);var f=d.getEntry(this.id);strictEqual(f,undefined,"editorRegistry has entry removed after `unregister` event")});test("Should remove entry correctly upon unregistration after switching modes",function(){d._registerTextMode(this.textArea);d._registerVisualMode(new e());d._switchMode(this.textArea,b.TEXT);d._unregister(this.textArea);var f=d.getEntry(this.id);strictEqual(f,undefined,"editorRegistry has entry removed after `unregister` event")});test("Should trigger `switch` events on the first Text->Visual switch (via `_registerVisualMode` call)",function(){d._registerTextMode(this.textArea);d._registerVisualMode(new e());var f=this.getExpectedEntry(b.VISUAL);var g=d._triggerEvents;ok(g.calledTwice,"_triggerEvents called twice");ok(g.secondCall.calledWithMatch(sinon.match("switch"),c(f)),"_triggerEvents called with correct arguments")});test("Should trigger `switch` events when repetitively switching modes",function(){d._registerTextMode(this.textArea);var h=10;for(var g=0;g<h;g++){var k=(g%2===0)?b.VISUAL:b.TEXT;d._switchMode(this.textArea,k)}var f=this.getExpectedEntry(b.TEXT);var j=d._triggerEvents;ok(j.callCount,h+1,"_triggerEvents called "+(h+1)+" times");ok(j.firstCall.calledWithMatch(sinon.match("register"),c(f)),"_triggerEvents called with correct arguments");for(g=0;g<h;g++){ok(j.calledWith("switch"),"_triggerEvents called for `switch` #"+(g+1))}});test("Should NOT trigger `switch` events when calling `_switch` passing the current mode",function(){d._registerTextMode(this.textArea);d._switchMode(this.textArea,b.TEXT);var f=this.getExpectedEntry(b.TEXT);var g=d._triggerEvents;ok(g.calledOnce,"_triggerEvents called once");ok(g.firstCall.calledWithMatch(sinon.match("register"),c(f)),"_triggerEvents called with correct arguments");ok(g.neverCalledWith("switch"),"_triggerEvents not called for `switch` events")});function c(f){return function(g){for(var h in f){if(f.hasOwnProperty(h)&&f[h]!==g[h]){return false}}return true}}});