/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dnd.attachment.providers;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.attachment.AttachmentService;
import com.atlassian.jira.plugin.webfragment.contextproviders.AbstractJiraContextProvider;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.HashMap;
import java.util.Map;
import webwork.config.Configuration;

public class MetadataContextProvider
extends AbstractJiraContextProvider {
    private final AttachmentService attachmentService;

    public MetadataContextProvider(AttachmentService attachmentService) {
        this.attachmentService = attachmentService;
    }

    public Map getContextMap(ApplicationUser applicationUser, JiraHelper jiraHelper) {
        HashMap<String, String> map = new HashMap<String, String>();
        Project project = jiraHelper.getProject();
        map.put("canAttach", this.canAttach(applicationUser, project).toString());
        if (project != null && project.getProjectTypeKey() != null) {
            map.put("projectType", project.getProjectTypeKey().getKey());
        } else {
            map.put("projectType", "");
        }
        map.put("uploadLimit", Configuration.getString((String)"webwork.multipart.maxSize"));
        return map;
    }

    private Boolean canAttach(ApplicationUser applicationUser, Project project) {
        JiraServiceContextImpl context = new JiraServiceContextImpl(applicationUser, (ErrorCollection)new SimpleErrorCollection());
        return this.attachmentService.canCreateAttachments((JiraServiceContext)context, project);
    }
}

