/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.corereports.web.action;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.plugin.report.ReportModuleDescriptor;
import com.atlassian.jira.project.Project;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
class ReportProjectContextResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ReportProjectContextResolver.class);
    private static final String PARAMETER_SELECTED_PROJECT_ID = "selectedProjectId";
    private static final String FIELD_TYPE_FILTER_OR_PROJECT_PICKER = "filterprojectpicker";
    private static final Pattern PATTERN_MATCH_SELECTED_PROJECT = Pattern.compile("project-([0-9]+)");
    private static final int PATTERN_PROJECT_ID_GROUP_INDEX = 1;
    private final ProjectService projectService;

    @Inject
    public ReportProjectContextResolver(@ComponentImport ProjectService projectService) {
        this.projectService = projectService;
    }

    public Optional<Project> getProjectContext(ReportModuleDescriptor report, HttpServletRequest request) {
        List projectIdsInRequest = (List)this.getProjectContextParameterValues(report, request).stream().map(this::matchProjectIdFromParameterValue).filter(Optional::isPresent).map(Optional::get).collect(CollectorsUtil.toImmutableList());
        if (projectIdsInRequest.size() == 1) {
            return Optional.ofNullable(Iterables.getFirst((Iterable)projectIdsInRequest, null)).flatMap(this::getProjectById);
        }
        return this.getDefaultSelectedProjectId(request).flatMap(this::getProjectById);
    }

    private Optional<Project> getProjectById(Long projectId) {
        return Optional.ofNullable(this.projectService.getProjectById(projectId).getProject());
    }

    private Optional<Long> getDefaultSelectedProjectId(HttpServletRequest request) {
        return Optional.ofNullable(request.getParameter(PARAMETER_SELECTED_PROJECT_ID)).map(Long::valueOf);
    }

    private Set<String> getProjectContextParameterValues(ReportModuleDescriptor report, HttpServletRequest request) {
        try {
            ObjectConfiguration configuration = this.getEmptyReportObjectConfiguration(report);
            HashSet<String> projectContextParameters = new HashSet<String>();
            for (String fieldKey : configuration.getFieldKeys()) {
                String param;
                String fieldType = configuration.getFieldTypeName(fieldKey);
                if (!this.isProjectCentricFieldType(fieldType) || (param = request.getParameter(fieldKey)) == null) continue;
                projectContextParameters.add(param);
            }
            return projectContextParameters;
        }
        catch (ObjectConfigurationException e) {
            LOG.warn("Invalid ObjectConfiguration, can't resolve project", (Throwable)e);
            return Collections.emptySet();
        }
    }

    private ObjectConfiguration getEmptyReportObjectConfiguration(ReportModuleDescriptor report) throws ObjectConfigurationException {
        return report.getObjectConfiguration(Collections.emptyMap());
    }

    private Optional<Long> matchProjectIdFromParameterValue(String value) {
        return Optional.of(value).map(PATTERN_MATCH_SELECTED_PROJECT::matcher).filter(Matcher::find).map(matcher -> matcher.group(1)).map(Long::valueOf);
    }

    private boolean isProjectCentricFieldType(String fieldTypeName) {
        return fieldTypeName.equals(FIELD_TYPE_FILTER_OR_PROJECT_PICKER);
    }
}

