/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.corereports.web.action;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.web.action.browser.ReportConfiguredEvent;
import com.atlassian.jira.event.web.action.browser.ReportViewedEvent;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugin.corereports.fieldtype.FieldTypeModuleDescriptor;
import com.atlassian.jira.plugin.corereports.web.action.ReportProjectContextResolver;
import com.atlassian.jira.plugin.report.Report;
import com.atlassian.jira.plugin.report.ReportModuleDescriptor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.projects.api.sidebar.ProjectSidebarRenderer;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.seraph.util.RedirectUtils;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import webwork.action.ActionContext;

@Named
public class ConfigureReport
extends ProjectActionSupport {
    private static final String CONFIGURE_REPORTS_CONTEXT = "com.atlassian.jira.jira-core-reports-plugin.configure-report";
    private static final String REPORT_RESULT_CONTEXT = "com.atlassian.jira.jira-core-reports-plugin.report-result";
    private final PluginAccessor pluginAccessor;
    private final EventPublisher eventPublisher;
    private final PageBuilderService page;
    private final SoyTemplateRenderer soy;
    private final ApplicationProperties appProperties;
    private final ProjectSidebarRenderer projectSidebarRenderer;
    private final ReportProjectContextResolver reportResultProjectContextResolver;
    private String reportKey;
    private ReportModuleDescriptor descriptor;
    private ObjectConfiguration oc;
    private String generatedReport;
    private Report report;

    @Inject
    public ConfigureReport(@ComponentImport ProjectManager projectManager, @ComponentImport PermissionManager permissionManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport EventPublisher eventPublisher, @ComponentImport PageBuilderService page, @ComponentImport SoyTemplateRenderer soy, @ComponentImport ApplicationProperties appProperties, @ComponentImport ProjectSidebarRenderer projectSidebarRenderer, ReportProjectContextResolver reportResultProjectContextResolver) {
        super(projectManager, permissionManager);
        this.pluginAccessor = pluginAccessor;
        this.eventPublisher = eventPublisher;
        this.page = page;
        this.soy = soy;
        this.appProperties = appProperties;
        this.projectSidebarRenderer = projectSidebarRenderer;
        this.reportResultProjectContextResolver = reportResultProjectContextResolver;
    }

    public String getParamValue(String key) {
        String value;
        block3: {
            Map<String, Object> inputParams = this.makeReportParams();
            value = (String)inputParams.get(key);
            if (value == null) {
                try {
                    value = this.getObjectConfiguration().getFieldDefault(key);
                }
                catch (ObjectConfigurationException objectConfigurationException) {
                    if (!this.log.isDebugEnabled()) break block3;
                    this.log.debug((Object)String.format("The configuration property with the key: %s could not be found for the report module descriptor with the key: %s", key, this.reportKey), (Throwable)objectConfigurationException);
                }
            }
        }
        return value;
    }

    @ActionViewData(key="sidebarHtml")
    public String getSidebarHtml() {
        return this.projectSidebarRenderer.render(this.getSelectedProject(), "com.atlassian.jira.jira-projects-plugin:report-page");
    }

    public List<String> getParamValues(String key) {
        Map<String, Object> inputParams = this.makeReportParams();
        Object values = inputParams.get(key);
        if (values == null) {
            try {
                values = this.getObjectConfiguration().getFieldDefault(key);
            }
            catch (ObjectConfigurationException objectConfigurationException) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("The configuration property with the key: %s could not be found for the report module descriptor with the key: %s", key, this.reportKey), (Throwable)objectConfigurationException);
                }
                return Collections.emptyList();
            }
        } else if (values instanceof String[]) {
            return Arrays.asList((String[])values);
        }
        return Collections.singletonList(values.toString());
    }

    public String doDefault() throws Exception {
        if (!this.validReport()) {
            return "noreporterror";
        }
        this.eventPublisher.publish((Object)new ReportConfiguredEvent(this.getReportKey()));
        this.page.assembler().resources().requireContext(CONFIGURE_REPORTS_CONTEXT);
        return super.doDefault();
    }

    protected String doExecute() throws Exception {
        if (!this.validReport()) {
            return "noreporterror";
        }
        this.getReportModule().validate((ProjectActionSupport)this, this.makeReportParams());
        if (this.getReasons().contains(ErrorCollection.Reason.NOT_LOGGED_IN)) {
            return this.forceRedirect(RedirectUtils.getLoginUrl((HttpServletRequest)this.request));
        }
        if (this.invalidInput()) {
            return "input";
        }
        this.generatedReport = this.getReportModule().generateReportHtml((ProjectActionSupport)this, this.makeReportParams());
        this.eventPublisher.publish((Object)new ReportViewedEvent(this.getReportKey()));
        this.page.assembler().resources().requireContext(REPORT_RESULT_CONTEXT);
        return "success";
    }

    public Project getSelectedProject() {
        return this.reportResultProjectContextResolver.getProjectContext(this.getReport(), this.getHttpRequest()).orElse(super.getSelectedProject());
    }

    private boolean validReport() {
        if (StringUtils.isEmpty((String)this.getReportKey())) {
            this.addErrorMessage(this.getText("report.configure.error.no.report.key"));
            return false;
        }
        if (this.getReport() == null || !this.getReportModule().showReport()) {
            this.addErrorMessage(this.getText("report.configure.error.no.report", this.getReportKey()));
            return false;
        }
        return true;
    }

    public String doExcelView() throws Exception {
        this.getHttpResponse().setHeader("Cache-Control", "private, must-revalidate, max-age=5");
        this.getHttpResponse().setHeader("Pragma", "");
        this.getHttpResponse().setDateHeader("Expires", System.currentTimeMillis() + 300L);
        this.getHttpResponse().setContentType("application/vnd.ms-excel;charset=" + this.getEncoding());
        this.generatedReport = this.getReportModule().generateReportExcel((ProjectActionSupport)this, this.makeReportParams());
        return "excel";
    }

    private Map<String, Object> makeReportParams() {
        Map params = ActionContext.getParameters();
        LinkedHashMap<String, Object> reportParams = new LinkedHashMap<String, Object>(params.size());
        for (Map.Entry entry : params.entrySet()) {
            String key = (String)entry.getKey();
            if (((String[])entry.getValue()).length == 1) {
                reportParams.put(key, ((String[])entry.getValue())[0]);
                continue;
            }
            reportParams.put(key, entry.getValue());
        }
        return reportParams;
    }

    @ActionViewData(key="queryString")
    public String getQueryString() {
        Map<String, Object> params = this.makeReportParams();
        StringBuilder stringBuilder = new StringBuilder();
        boolean isFirstKey = true;
        for (String key : params.keySet()) {
            Object value = params.get(key);
            if (value instanceof String) {
                isFirstKey = this.appendUrlParameter(isFirstKey, key, (String)value, stringBuilder);
                continue;
            }
            if (!(value instanceof String[])) continue;
            for (int i = 0; i < ((String[])value).length; ++i) {
                String s = ((String[])value)[i];
                isFirstKey = this.appendUrlParameter(isFirstKey, key, s, stringBuilder);
            }
        }
        return stringBuilder.toString();
    }

    @ActionViewData(key="encoding")
    public String getEncoding() {
        return this.appProperties.getEncoding();
    }

    private boolean appendUrlParameter(boolean firstKey, String key, String value, StringBuilder stringBuilder) {
        if (firstKey) {
            stringBuilder.append(this.encode(key)).append('=').append(this.encode(value));
        } else {
            stringBuilder.append('&').append(this.encode(key)).append('=').append(this.encode(value));
        }
        return false;
    }

    private String encode(String key) {
        return JiraUrlCodec.encode((String)key);
    }

    private Report getReportModule() {
        if (this.report == null) {
            this.report = this.getReport().getModule();
        }
        return this.report;
    }

    @ActionViewData(key="generatedReportContent")
    public String getGeneratedReport() {
        return this.generatedReport;
    }

    @ActionViewData(key="reportKey")
    public String getReportKey() {
        return this.reportKey;
    }

    public void setReportKey(String reportKey) {
        this.reportKey = reportKey;
    }

    @ActionViewData(key="report")
    public ReportModuleDescriptor getReport() {
        if (this.descriptor == null) {
            this.descriptor = (ReportModuleDescriptor)this.pluginAccessor.getEnabledPluginModule(this.reportKey);
        }
        return this.descriptor;
    }

    @ActionViewData(key="errorMessages")
    public Collection<String> getFlushedErrorMessages() {
        return super.getFlushedErrorMessages();
    }

    @ActionViewData(key="selectedProjectId")
    public Long getSelectedProjectId() {
        return super.getSelectedProjectId();
    }

    @ActionViewData(key="atlToken")
    public String getAtlToken() {
        return this.getXsrfToken();
    }

    @ActionViewData(key="objectConfiguration")
    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        if (this.oc == null) {
            Map objectConfigurationParameters = MapBuilder.build((Object)"project", (Object)(this.getSelectedProject() == null ? null : this.getSelectedProject().getGenericValue()), (Object)"User", (Object)this.getLoggedInUser());
            this.oc = this.getReport().getObjectConfiguration(objectConfigurationParameters);
        }
        return this.oc;
    }

    @ActionViewData(key="objectConfigurationFields")
    public Collection<? extends ObjectConfigurationField> getObjectConfigurationFields() throws ObjectConfigurationException {
        ObjectConfiguration objectConfiguration = this.getObjectConfiguration();
        return Stream.of(objectConfiguration.getFieldKeys()).map(key -> new ObjectConfigurationField((String)key, objectConfiguration)).collect(Collectors.toList());
    }

    @ActionViewData(key="loginAdvisable")
    public boolean getLoginAdvisable() {
        return this.getLoggedInApplicationUser() == null && this.hasAnyErrors();
    }

    @ActionViewData(key="loginAdviceMessage")
    public String getLoginAdviceMessage() {
        StringBuilder loginLink = new StringBuilder("<a rel=\"nofollow\" href=\"");
        loginLink.append(RedirectUtils.getLinkLoginURL((HttpServletRequest)this.request));
        loginLink.append("\">");
        return this.getText("report.loginadvised", loginLink.toString(), "</a>");
    }

    @ActionViewData(key="showSaveButton")
    public boolean isShowSaveButton() throws ObjectConfigurationException {
        for (ObjectConfigurationField objectConfigurationField : this.getObjectConfigurationFields()) {
            if (objectConfigurationField.getType() != 2 || !objectConfigurationField.getValues().isEmpty()) continue;
            return false;
        }
        return !Boolean.FALSE.equals(this.getHttpRequest().getAttribute("jira.portletform.showsavebutton"));
    }

    public String getFilterProjectName(String key) {
        return this.getParamValue("projectOrFilterName");
    }

    public String getFilterName(String key) {
        return this.getParamValue("filterName");
    }

    private static <T> List<? extends T> mapAndConvertToList(Map<?, ?> fieldValues, Function<Map.Entry<?, ?>, T> mapper) {
        return fieldValues.entrySet().stream().map(mapper).collect(Collectors.toList());
    }

    public static final class DatePickerParameter {
        private final String key;
        private final String value;

        public DatePickerParameter(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }

    public class SelectableFieldOption
    extends FieldOption {
        private final boolean selected;

        public SelectableFieldOption(String value, String text, boolean selected) {
            super(value, text);
            this.selected = selected;
        }

        public boolean getSelected() {
            return this.selected;
        }
    }

    public class FieldOption {
        private final String value;
        private final String text;

        public FieldOption(String value, String text) {
            this.text = text;
            this.value = value;
        }

        public String getText() {
            return ConfigureReport.this.getText(this.text);
        }

        public String getValue() {
            return this.value;
        }
    }

    public class ObjectConfigurationField {
        private final ObjectConfiguration objectConfiguration;
        private final String fieldKey;

        public ObjectConfigurationField(String fieldKey, ObjectConfiguration objectConfiguration) {
            this.fieldKey = fieldKey;
            this.objectConfiguration = objectConfiguration;
        }

        public boolean isEnabled() {
            return this.objectConfiguration.isEnabled(this.fieldKey);
        }

        public String getName() throws ObjectConfigurationException {
            return this.objectConfiguration.getFieldName(this.fieldKey);
        }

        public String getKey() {
            return this.fieldKey;
        }

        public String getParamValue() {
            return ConfigureReport.this.getParamValue(this.fieldKey);
        }

        public List<String> getParamValues() {
            return ConfigureReport.this.getParamValues(this.fieldKey);
        }

        public String getDescription() throws ObjectConfigurationException {
            return this.objectConfiguration.getFieldDescription(this.fieldKey);
        }

        public String getDefaultValue() throws ObjectConfigurationException {
            return this.objectConfiguration.getFieldDefault(this.fieldKey);
        }

        public String getFilterProjectName() {
            return ConfigureReport.this.getFilterProjectName(this.fieldKey);
        }

        public String getFilterName() {
            return ConfigureReport.this.getFilterName(this.fieldKey);
        }

        public List<? extends FieldOption> getValues() throws ObjectConfigurationException {
            return ConfigureReport.mapAndConvertToList(this.objectConfiguration.getFieldValues(this.fieldKey), this::toFieldOption);
        }

        public List<? extends FieldOption> getValuesHtmlEncoded() throws ObjectConfigurationException {
            return ConfigureReport.mapAndConvertToList(this.objectConfiguration.getFieldValuesHtmlEncoded(this.fieldKey), this::toFieldOption);
        }

        public List<? extends SelectableFieldOption> getSelectableValuesHtmlEncoded() throws ObjectConfigurationException {
            return ConfigureReport.mapAndConvertToList(this.objectConfiguration.getFieldValuesHtmlEncoded(this.fieldKey), this.toSelectableFieldOption());
        }

        private FieldOption toFieldOption(Map.Entry<?, ?> entry) {
            return new FieldOption(entry.getKey().toString(), entry.getValue().toString());
        }

        private Function<Map.Entry<?, ?>, SelectableFieldOption> toSelectableFieldOption() {
            HashSet<String> paramValues = new HashSet<String>(this.getParamValues());
            return entry -> {
                String value = entry.getValue().toString();
                String key = entry.getKey().toString();
                return new SelectableFieldOption(key, value, paramValues.contains(key));
            };
        }

        public boolean getUserPickerPermission() {
            return ConfigureReport.this.hasGlobalPermission(GlobalPermissionKey.USER_PICKER);
        }

        public int getType() throws ObjectConfigurationException {
            return this.objectConfiguration.getFieldType(this.fieldKey);
        }

        public String getTypeName() throws ObjectConfigurationException {
            return this.objectConfiguration.getFieldTypeName(this.fieldKey);
        }

        public String getErrorMessage() {
            return (String)ConfigureReport.this.getErrors().get(this.fieldKey);
        }

        public String getConfigurationHtml() throws ObjectConfigurationException {
            FieldTypeModuleDescriptor descriptor = this.findFieldType();
            if (descriptor == null) {
                return null;
            }
            return descriptor.getHtml("view", Collections.singletonMap("field", this));
        }

        public Collection<DatePickerParameter> getDatePickerParameters() {
            Calendar calendar = Calendar.getInstance(ConfigureReport.this.getLocale());
            Date now = DateTime.now().toDate();
            String startingTimestamp = ConfigureReport.this.getDmyDateFormatter().format(now);
            boolean useISO8601WeekNumbers = ConfigureReport.this.appProperties.getOption("jira.date.time.picker.use.iso8061");
            return ImmutableList.of((Object)new DatePickerParameter("firstDay", Integer.toString(calendar.getFirstDayOfWeek() - 1)), (Object)new DatePickerParameter("date", startingTimestamp), (Object)new DatePickerParameter("todayDate", startingTimestamp), (Object)new DatePickerParameter("useISO8601WeekNumbers", Boolean.toString(useISO8601WeekNumbers)), (Object)new DatePickerParameter("ifFormat", ConfigureReport.this.getDateFormat()));
        }

        private FieldTypeModuleDescriptor findFieldType() throws ObjectConfigurationException {
            List fieldTypes = ConfigureReport.this.pluginAccessor.getEnabledModuleDescriptorsByClass(FieldTypeModuleDescriptor.class);
            String fieldTypeKey = this.getTypeName();
            if (fieldTypeKey == null) {
                return null;
            }
            for (FieldTypeModuleDescriptor fieldType : fieldTypes) {
                if (!fieldTypeKey.equals(fieldType.getKey())) continue;
                return fieldType;
            }
            return null;
        }
    }
}

