/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.corereports.report.impl;

import com.atlassian.jira.plugin.corereports.report.impl.DurationFormatter;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraDurationUtils;

class DurationFormatterImpl
implements DurationFormatter {
    private final JiraDurationUtils jiraDurationUtils;
    private final I18nHelper i18nHelper;

    DurationFormatterImpl(I18nHelper i18nHelper, JiraDurationUtils jiraDurationUtils) {
        this.i18nHelper = i18nHelper;
        this.jiraDurationUtils = jiraDurationUtils;
    }

    @Override
    public String format(Long duration) {
        if (duration == null) {
            return "-";
        }
        duration = Math.abs(duration);
        return this.jiraDurationUtils.getFormattedDuration(duration, this.i18nHelper.getLocale());
    }

    @Override
    public String shortFormat(Long duration) {
        if (duration == null) {
            return "-";
        }
        duration = Math.abs(duration);
        return this.jiraDurationUtils.getShortFormattedDuration(duration);
    }
}

