/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.corereports.charts.report;

import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.charts.Chart;
import com.atlassian.jira.charts.ChartFactory;
import com.atlassian.jira.charts.report.AbstractChartReport;
import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class PieReport
extends AbstractChartReport {
    private final ChartFactory chartFactory;

    @Inject
    public PieReport(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport ProjectManager projectManager, @ComponentImport SearchRequestService searchRequestService, @ComponentImport ChartUtils chartUtils, @ComponentImport ChartFactory chartFactory) {
        super(authenticationContext, applicationProperties, projectManager, searchRequestService, chartUtils);
        this.chartFactory = chartFactory;
    }

    public void validate(ProjectActionSupport action, Map params) {
        this.validateProjectOrFilterId(action, params);
    }

    public String generateReportHtml(ProjectActionSupport action, Map reqParams) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("report", (Object)this);
        params.put("action", action);
        params.put("user", this.authenticationContext.getUser());
        String projectOrFilterId = (String)reqParams.get("projectOrFilterId");
        String statisticType = (String)reqParams.get("statistictype");
        SearchRequest request = this.chartUtils.retrieveOrMakeSearchRequest(projectOrFilterId, params);
        params.put("projectOrFilterId", projectOrFilterId);
        ChartFactory.ChartContext context = new ChartFactory.ChartContext(this.authenticationContext.getUser(), request, 800, 500, true);
        Chart chart = this.chartFactory.generatePieChart(context, statisticType);
        params.putAll(chart.getParameters());
        return this.descriptor.getHtml("view", params);
    }
}

