/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.core.service;

import com.atlassian.application.api.ApplicationManager;
import com.atlassian.application.api.PlatformApplication;
import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.shortcuts.ProjectShortcut;
import com.atlassian.jira.projects.shortcuts.ShortcutsService;
import com.atlassian.jira.security.JiraAuthenticationContext;

public class CoreProjectShortcutGenerator {
    private final JiraAuthenticationContext authenticationContext;
    private final ShortcutsService shortcutsService;
    private final HelpUrls helpUrls;
    private final ApplicationManager applicationManager;

    public CoreProjectShortcutGenerator(JiraAuthenticationContext authenticationContext, ShortcutsService shortcutsService, HelpUrls helpUrls, ApplicationManager applicationManager) {
        this.authenticationContext = authenticationContext;
        this.shortcutsService = shortcutsService;
        this.helpUrls = helpUrls;
        this.applicationManager = applicationManager;
    }

    public void generateShortcutForProject(Project project, String helpUrlKey) {
        if (this.helpUrls.getUrlKeys().contains(helpUrlKey)) {
            PlatformApplication coreApp = this.applicationManager.getPlatform();
            HelpUrl url = this.helpUrls.getUrlForApplication(coreApp.getKey(), helpUrlKey);
            ProjectShortcut projectShortcut = new ProjectShortcut(url.getTitle(), url.getUrl(), "", project);
            this.shortcutsService.addShortcut(projectShortcut, this.authenticationContext.getLoggedInUser());
        }
    }
}

