/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.core.hook;

import com.atlassian.jira.blueprint.api.ProjectCreateHookHelper;
import com.atlassian.jira.config.ResolutionManager;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.template.hook.ConfigureData;
import com.atlassian.jira.project.template.hook.ConfigureResponse;
import com.atlassian.jira.project.template.hook.EmptyAddProjectHook;
import com.atlassian.jira.projecttemplates.core.service.CoreProjectShortcutGenerator;
import com.atlassian.jira.workflow.JiraWorkflow;

public class ProjectManagementProjectCreateHook
extends EmptyAddProjectHook {
    private static final String DONE_ACTION_NAME = "Done";
    private static final String REOPEN_ACTION_NAME = "Reopen";
    private static final String REOPEN_START_PROGRESS_ACTION_NAME = "Reopen and start progress";
    private static final String WORKFLOW_KEY = "WF1";
    private final ProjectCreateHookHelper projectCreateHookHelper;
    private final CoreProjectShortcutGenerator coreProjectShortcutGenerator;
    private final ResolutionManager resolutionManager;

    public ProjectManagementProjectCreateHook(ProjectCreateHookHelper projectCreateHookHelper, CoreProjectShortcutGenerator coreProjectShortcutGenerator, ResolutionManager resolutionManager) {
        this.projectCreateHookHelper = projectCreateHookHelper;
        this.coreProjectShortcutGenerator = coreProjectShortcutGenerator;
        this.resolutionManager = resolutionManager;
    }

    public ConfigureResponse configure(ConfigureData configureData) {
        ConfigureResponse response = ConfigureResponse.create();
        JiraWorkflow jiraWorkflow = (JiraWorkflow)configureData.createdWorkflows().get(WORKFLOW_KEY);
        if (jiraWorkflow == null) {
            throw new IllegalArgumentException("Workflow with key 'WF1' not found.");
        }
        this.projectCreateHookHelper.addResolutionValuePostFunction("", jiraWorkflow, REOPEN_ACTION_NAME);
        this.projectCreateHookHelper.addResolutionValuePostFunction("", jiraWorkflow, REOPEN_START_PROGRESS_ACTION_NAME);
        this.projectCreateHookHelper.addPermissionCondition(ProjectPermissions.RESOLVE_ISSUES, jiraWorkflow, DONE_ACTION_NAME);
        this.projectCreateHookHelper.addPermissionCondition(ProjectPermissions.RESOLVE_ISSUES, jiraWorkflow, REOPEN_ACTION_NAME);
        Resolution resolution = this.resolutionManager.getDefaultResolution();
        if (resolution == null) {
            resolution = (Resolution)this.resolutionManager.getResolutions().stream().findFirst().get();
        }
        this.projectCreateHookHelper.addResolutionValuePostFunction(resolution.getId(), jiraWorkflow, DONE_ACTION_NAME);
        this.projectCreateHookHelper.applyWorkflowChanges(jiraWorkflow);
        this.coreProjectShortcutGenerator.generateShortcutForProject(configureData.project(), "project.template.shortcuts.core.jira-core-project-management");
        this.coreProjectShortcutGenerator.generateShortcutForProject(configureData.project(), "project.template.shortcuts.core.general");
        return response;
    }
}

