require(["internal/browser-metrics", "jira/util/events"], function (internal_browser_metrics, jira_util_events) {
var sensors_application_menus = {}, sensors_util_safe_dialog_id = {}, sensors_dialogs = {}, sensors = {};
sensors_application_menus = function (exports, Events, metrics) {
  function init() {
    var KEYS = {
      'bonfire_top_menu_dropdown-content': 'jira.header.menu.capture',
      'browse_link-content': 'jira.header.menu.projects',
      'find_link-content': 'jira.header.menu.issues',
      'greenhopper_menu-content': 'jira.header.menu.agile',
      'home_link-content': 'jira.header.menu.dashboards',
      'plugins-jira-webitem-main-content': 'jira.header.menu.portfolio',
      'servicedesk-section-content': 'jira.header.menu.service-desk',
      'system-admin-menu-content': 'jira.header.menu.admin',
      'system-help-menu-content': 'jira.header.menu.help',
      'user-options-content': 'jira.header.menu.profile'
    };
    function getKey(dropdownId) {
      return KEYS.hasOwnProperty(dropdownId) ? KEYS[dropdownId] : null;
    }
    Events.bind('aui-dropdown2-show-before', function (event) {
      var target = event.target;
      var key = getKey(target && target.id);
      if (key) {
        metrics.start({
          key: key,
          isInitial: false,
          threshold: 250
        });
      }
    });
    Events.bind('aui-dropdown2-show-after', function (event) {
      var target = event.target;
      var key = getKey(target && target.id);
      if (key) {
        metrics.end({ key: key });
      }
    });
  }
  exports.init = init;
  return exports;
}(sensors_application_menus, jira_util_events, internal_browser_metrics);
sensors_util_safe_dialog_id = function (exports) {
  var SAFE_DIALOG_IDS = [
    'about-dialog',
    'add-basicuser-dialog',
    'add-developer-dialog',
    'add-field-configuration-dialog',
    'add-field-configuration-scheme-dialog',
    'add-field-dialog',
    'add-field-screen-dialog',
    'add-field-screen-scheme-dialog',
    'add-incoming-mail-handler-dialog',
    'add-issue-type-dialog',
    'add-issue-type-field-configuration-association-dialog',
    'add-issue-type-screen-scheme-configuration-association-dialog',
    'add-issue-type-screen-scheme-dialog',
    'add-new-issue-type-to-scheme-dialog',
    'add-screen-scheme-item-dialog',
    'add-subtask-type-dialog',
    'add-workflow-dialog',
    'add_workflowscheme-dialog',
    'assign-dialog',
    'assign-issue-types-dialog',
    'assign-to-me-link-handler',
    'attach-file-dialog',
    'attach-screenshot-dialog',
    'auditing-settings-dialog',
    'clone-issue-dialog',
    'comment-add-dialog',
    'configure_wallboard_dialog',
    'confluence-page-search-dialog',
    'copy_classic default workflow-dialog',
    'copy-filter-dialog',
    'copy_jira-dialog',
    'create-issue-dialog',
    'create-issue-dialog.issueType',
    'create-issue-dialog.projectId',
    'create-request-dialog',
    'create-service-desk-dialog',
    'create-status-dialog',
    'create-story-dialog',
    'create-story-dialog.issueType',
    'create-story-dialog.projectId',
    'create-subtask-dialog',
    'create-subtask-dialog.issueType',
    'create-team-dialog',
    'create_user-dialog',
    'credits-dialog',
    'delete-attachment-dialog',
    'delete-comment-dialog',
    'delete-dshboard',
    'delete-filter-dialog',
    'delete-issue-dialog',
    'delete-issue-link-dialog',
    'delete-log-work-dialog',
    'delete-metric',
    'delete-queue',
    'delete-status-dialog',
    'deleteuser_link-dialog',
    'devstatus-branch-detail-dialog',
    'devstatus-build-detail-dialog',
    'devstatus-commit-detail-dialog',
    'devstatus-cta-dialog',
    'devstatus-deployment-detail-dialog',
    'devstatus-pullrequest-detail-dialog',
    'devstatus-review-detail-dialog',
    'discard-draft-dialog',
    'discard_draft_workflow-dialog',
    'edit-attachments-dialog',
    'edit-comment',
    'editgroups_admin-dialog',
    'editgroups_link-dialog',
    'editgroups_sysadmin-dialog',
    'edit-issue-dialog',
    'edit-labels-dialog',
    'edit-log-work-dialog',
    'edit-status-dialog',
    'edituser_link_admin-dialog',
    'edit-workflow-dialog',
    'gh-rapidboard-dialog',
    'inline-issue-create-dialog',
    'invite_user-dialog',
    'issue-actions-dialog',
    'issue-tab-error-dialog',
    'jim-create-project-dialog',
    'keyboard-shortcuts-dialog',
    'link-issue-dialog',
    'log-work-dialog',
    'manage-attachment-dialog',
    'metric-pre-save-dialog',
    'modal-field-view',
    'permission-helper-dialog',
    'project-avatar-cropper',
    'project-avatar-picker',
    'project-config-details-project-category-dialog',
    'project-config-project-edit-dialog',
    'project-config-project-edit-lead-and-default-assignee-dialog',
    'project-email-dialog',
    'publish_draft_workflow-dialog',
    'queue-dirty-edits',
    'QuickCreateIssue.error',
    'QuickCreateIssue.success',
    'QuickCreateSubtask.error',
    'QuickCreateSubtask.success',
    'QuickEdit.error',
    'QuickEdit.success',
    'remote-jira-search-dialog',
    'rename-filter-dialog',
    'report-dirty-edits',
    'save-filter-dialog',
    'sd-add-default-value',
    'sd-add-remove-agent-dialog',
    'sd-remove-field-dialog',
    'server-error-dialog',
    'report-delete-confirm',
    'tempo-add-hours-issue-dialog',
    'tempo-add-internal-activity-form',
    'tempo-core-medium-form',
    'tempo-delete-form-dialog',
    'tempo-grace-form',
    'tempo-large-form',
    'tempo-medium-form',
    'tempo-move-form-dialog',
    'tempo-pdf-form',
    'tempo-small-form',
    'tempo-split-form-dialog',
    'tempo-user-settings-dialog',
    'user-avatar-picker',
    'user-defaults-edit-dialog',
    'versionsMergeDialog',
    'view-workflow-dialog',
    'view-workflow-dialog-project-admin',
    'view-workflow-dialog-workflow-schemes',
    'wait-migrate-dialog',
    'whereismycf-dialog',
    'workflow-text-view'
  ].reduce(function (previousValue, currentValue) {
    previousValue[currentValue] = true;
    return previousValue;
  }, {});
  var DIALOG_ID_NORMALISATIONS = [
    {
      dialogId: 'component-delete-dialog',
      pattern: /^component-\d+-delete-dialog$/i
    },
    {
      dialogId: 'version-delete-dialog',
      pattern: /^version-\d+-delete-dialog$/i
    },
    {
      dialogId: 'workflow-transition-dialog',
      pattern: /^workflow-transition-\d+-dialog$/i
    }
  ];
  function safeDialogId(dialogId) {
    var i;
    if (SAFE_DIALOG_IDS.hasOwnProperty(dialogId)) {
      return dialogId;
    }
    for (i = 0; i < DIALOG_ID_NORMALISATIONS.length; i++) {
      if (dialogId.match(DIALOG_ID_NORMALISATIONS[i].pattern)) {
        return DIALOG_ID_NORMALISATIONS[i].dialogId;
      }
    }
    return null;
  }
  return safeDialogId;
}(sensors_util_safe_dialog_id);
sensors_dialogs = function (exports, Events, metrics, safeDialogId) {
  function init() {
    Events.bind('beforeShow', function (event, dialogId) {
      if (typeof dialogId !== 'string') {
        return;
      }
      var key = safeDialogId(dialogId);
      if (key) {
        metrics.start({
          key: 'jira.dialog.open.' + key,
          isInitial: false,
          threshold: 1000
        });
      }
    });
    Events.bind('dialogContentReady', function (event, dialog) {
      if (typeof dialog.options.id !== 'string') {
        return;
      }
      var key = safeDialogId(dialog.options.id);
      if (key) {
        metrics.end({ key: 'jira.dialog.open.' + key });
      }
    });
  }
  exports.init = init;
  return exports;
}(sensors_dialogs, jira_util_events, internal_browser_metrics, sensors_util_safe_dialog_id);
sensors = function (exports, applicationMenusSensor, dialogsSensor) {
  applicationMenusSensor.init();
  dialogsSensor.init();
  return exports;
}(sensors, sensors_application_menus, sensors_dialogs);});
