window["browser-metrics-plugin"].install(function (done) {
    require(["internal/browser-metrics", "internal/browser-metrics-aa-beacon", "jquery"], function (internal_browser_metrics, internal_browser_metrics_aa_beacon, jquery) {
var contrib_lib_window = {}, contrib_reporters_application_hash = {}, contrib_aa_beacon_report_marshallers_application_hash = {}, contrib_reporters_application_version = {}, contrib_aa_beacon_report_marshallers_application_version = {}, contrib_reporters_server_duration = {}, contrib_aa_beacon_report_marshallers_server_duration = {}, contrib_reporters_database_duration = {}, contrib_aa_beacon_report_marshallers_database_duration = {}, contrib_reporters_correlation_id = {}, contrib_aa_beacon_report_marshallers_correlation_id = {}, contrib = {};
contrib_lib_window = function (exports) {
  return window;
}(contrib_lib_window);
contrib_reporters_application_hash = function (exports, window) {
  var dataKey = 'com.atlassian.jira.plugins.jira-browser-metrics:contrib.scm-commit-id';
  var scmCommitId = window.WRM.data.claim(dataKey);
  var report = scmCommitId ? { applicationHash: scmCommitId } : {};
  var scmCommitIdReporter = function () {
    return report;
  };
  return scmCommitIdReporter;
}(contrib_reporters_application_hash, contrib_lib_window);
contrib_aa_beacon_report_marshallers_application_hash = function (exports) {
  function isApplicationHashReport(report) {
    return typeof report['applicationHash'] === 'string';
  }
  var applicationHashMarshaller = function (report) {
    if (isApplicationHashReport(report)) {
      return { applicationHash: report.applicationHash };
    }
  };
  return applicationHashMarshaller;
}(contrib_aa_beacon_report_marshallers_application_hash);
contrib_reporters_application_version = function (exports, $) {
  var pendingReport = $.Deferred();
  $(function () {
    var metrics = {};
    var version = $('meta[name=application-name]').data('version');
    if (version) {
      metrics['applicationHash'] = version;
    }
    pendingReport.resolve(metrics);
  });
  var applicationVersionReporter = function (transition) {
    if (transition.isInitial) {
      return pendingReport.promise();
    }
    return {};
  };
  return applicationVersionReporter;
}(contrib_reporters_application_version, jquery);
contrib_aa_beacon_report_marshallers_application_version = function (exports) {
  function isApplicationVersionReport(report) {
    return typeof report['applicationVersion'] === 'string';
  }
  var applicationVersionMarshaller = function (report) {
    if (isApplicationVersionReport(report)) {
      return { applicationVersion: report.applicationVersion };
    }
  };
  return applicationVersionMarshaller;
}(contrib_aa_beacon_report_marshallers_application_version);
contrib_reporters_server_duration = function (exports, $) {
  var pendingReport = $.Deferred();
  function isNumberString(value) {
    return '' + Number(value) === value;
  }
  $(function () {
    var metrics = {};
    var server = $('#jira_request_timing_info').find('[title=jira\\.request\\.server\\.time]').val();
    if (server && isNumberString(server)) {
      metrics['serverDuration'] = Number(server);
    }
    pendingReport.resolve(metrics);
  });
  var serverTimerReporter = function (transition) {
    if (transition.isInitial) {
      return pendingReport.promise();
    }
    return {};
  };
  return serverTimerReporter;
}(contrib_reporters_server_duration, jquery);
contrib_aa_beacon_report_marshallers_server_duration = function (exports) {
  function isServerDurationReport(report) {
    return typeof report['serverDuration'] === 'number';
  }
  var serverDurationMarshaller = function (report) {
    if (isServerDurationReport(report)) {
      return { serverDuration: '' + report.serverDuration };
    }
  };
  return serverDurationMarshaller;
}(contrib_aa_beacon_report_marshallers_server_duration);
contrib_reporters_database_duration = function (exports, $) {
  var pendingReport = $.Deferred();
  function isNumberString(value) {
    return '' + Number(value) === value;
  }
  $(function () {
    var metrics = {};
    var selector = '#jira_request_timing_info';
    var dbReads = $(selector).find('[title=db\\.reads\\.time\\.in\\.ms]').val();
    var dbConns = $(selector).find('[title=db\\.conns\\.time\\.in\\.ms]').val();
    if (dbReads && isNumberString(dbReads)) {
      metrics['dbReadsTimeInMs'] = Number(dbReads);
    }
    if (dbConns && isNumberString(dbConns)) {
      metrics['dbConnsTimeInMs'] = Number(dbConns);
    }
    pendingReport.resolve(metrics);
  });
  var databaseTimeReporter = function (transition) {
    if (transition.isInitial) {
      return pendingReport.promise();
    }
    return {};
  };
  return databaseTimeReporter;
}(contrib_reporters_database_duration, jquery);
contrib_aa_beacon_report_marshallers_database_duration = function (exports) {
  function isDatabaseDurationReport(report) {
    return typeof report['dbReadsTimeInMs'] === 'number' || typeof report['dbConnsTimeInMs'] === 'number';
  }
  var databaseDurationMarshaller = function (report) {
    if (isDatabaseDurationReport(report)) {
      return {
        dbReadsTimeInMs: '' + (report.dbReadsTimeInMs || ''),
        dbConnsTimeInMs: '' + (report.dbConnsTimeInMs || '')
      };
    }
  };
  return databaseDurationMarshaller;
}(contrib_aa_beacon_report_marshallers_database_duration);
contrib_reporters_correlation_id = function (exports, window) {
  var dataKey = 'jira.request.correlation-id';
  var correlationIdReporter = function (transition) {
    if (transition.isInitial) {
      var correlationId = window.WRM.data.claim(dataKey);
      var report = correlationId ? { correlationId: correlationId } : {};
      return report;
    }
    return {};
  };
  return correlationIdReporter;
}(contrib_reporters_correlation_id, contrib_lib_window);
contrib_aa_beacon_report_marshallers_correlation_id = function (exports) {
  function isCorrelationIdReport(report) {
    return typeof report['correlationId'] === 'string';
  }
  var correlationIdMarshaller = function (report) {
    if (isCorrelationIdReport(report)) {
      return { correlationId: report.correlationId };
    }
  };
  return correlationIdMarshaller;
}(contrib_aa_beacon_report_marshallers_correlation_id);
contrib = function (exports, applicationHashReporter, applicationHashReportMarshaller, applicationVersionReporter, applicationVersionReportMarshaller, serverDurationReporter, serverDurationReportMarshaller, databaseDurationReporter, databaseDurationReportMarshaller, correlationIdReporter, correlationIdReportMarshaller, metrics, aaBeacon) {
  var addReporter = metrics.addReporter;
  var addReportMarshaller = aaBeacon.addReportMarshaller;
  addReporter(applicationHashReporter);
  addReporter(applicationVersionReporter);
  addReporter(databaseDurationReporter);
  addReporter(serverDurationReporter);
  addReporter(correlationIdReporter);
  addReportMarshaller(applicationHashReportMarshaller);
  addReportMarshaller(applicationVersionReportMarshaller);
  addReportMarshaller(databaseDurationReportMarshaller);
  addReportMarshaller(serverDurationReportMarshaller);
  addReportMarshaller(correlationIdReportMarshaller);
  return exports;
}(contrib, contrib_reporters_application_hash, contrib_aa_beacon_report_marshallers_application_hash, contrib_reporters_application_version, contrib_aa_beacon_report_marshallers_application_version, contrib_reporters_server_duration, contrib_aa_beacon_report_marshallers_server_duration, contrib_reporters_database_duration, contrib_aa_beacon_report_marshallers_database_duration, contrib_reporters_correlation_id, contrib_aa_beacon_report_marshallers_correlation_id, internal_browser_metrics, internal_browser_metrics_aa_beacon);        done();
    });
});