(function () {

    "use strict";

    if (!require) {
        return;
    }

    require(['jquery', 'jira/flag'], function($, flag) {
        var $urlFlag;

        var BaseUrl = {
            jiraRestPath: contextPath + "/rest/api/2/settings/baseUrl",

            createBanner: function () {
                var requestUrl = BaseUrl.constructRequestUrl(parseUri(location));
                var content = JIRA.Templates.baseUrlMessage({
                    baseUrl: AJS.Meta.get("base-url"),
                    requestUrl: requestUrl
                });

                $urlFlag = $(flag.showWarningMsg('', content, { dismissalKey : 'com.atlassian.jira.baseurl'}));
                $urlFlag.find("#baseurl-update").click(function (e) {
                    e.preventDefault();
                    BaseUrl.updateBaseUrl(requestUrl);
                });

                return $urlFlag;
            },

            destroyBanner: function () {
                $urlFlag.find('.aui-icon.icon-close').click();
            },

            constructRequestUrl: function (request) {
                return request.protocol + "://" + request.authority + contextPath;
            },

            updateBaseUrl: function (baseUrl) {
                JIRA.SmartAjax.makeRequest({
                    url: BaseUrl.jiraRestPath,
                    type: "PUT",
                    data: baseUrl,
                    contentType: "application/json"
                }).done(function () {
                    JIRA.Messages.showSuccessMsg(AJS.I18n.getText("update.baseurl.success", "<a href='" + baseUrl + "'>" + baseUrl + "</a>"));
                });
                BaseUrl.destroyBanner();
            }
        };

        $(function() {
            if (!$('#base-url-banner').length) {
                BaseUrl.createBanner();
            }
        });
    });

}());
