/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.baseurl;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.jira.baseurl.BannerPreferences;
import com.atlassian.jira.baseurl.BaseUrl;
import com.atlassian.jira.plugin.webresource.JiraWebResourceManager;
import com.atlassian.jira.util.http.JiraUrl;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IncludeResourcesFilter
extends AbstractHttpFilter {
    private final JiraWebResourceManager webResourceManager;
    private final BaseUrl baseUrl;
    private final BannerPreferences bannerPreferences;

    public IncludeResourcesFilter(JiraWebResourceManager webResourceManager, BaseUrl baseUrl, BannerPreferences bannerPreferences) {
        this.webResourceManager = webResourceManager;
        this.baseUrl = baseUrl;
        this.bannerPreferences = bannerPreferences;
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String baseUrlFromRequest = JiraUrl.constructBaseUrl((HttpServletRequest)request);
        if (this.bannerPreferences.getShowBanner() && !this.baseUrl.isEquivalentTo(baseUrlFromRequest)) {
            this.webResourceManager.requireResource("com.atlassian.jira.jira-baseurl-plugin:baseurl-lib");
            this.webResourceManager.putMetadata("base-url", this.baseUrl.asString());
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

