/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.baseurl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import java.net.URI;
import java.net.URISyntaxException;

public class BaseUrl {
    private final ApplicationProperties applicationProperties;

    public BaseUrl(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public boolean isEquivalentTo(String uri) {
        try {
            return new URI(uri).equals(this.asUri());
        }
        catch (URISyntaxException invalidUriArguments) {
            return uri.equals(this.asString());
        }
    }

    public URI asUri() throws URISyntaxException {
        return new URI(this.asString());
    }

    public String asString() {
        return this.applicationProperties.getString("jira.baseurl");
    }
}

