require([
    'jquery'
], function(
    $
) {
    $(function(){
        // help tip for retention period
        var $actionsButton = $("#auditing-actions-button");
        var helpTipContent = $actionsButton.data("retention-period-help-tip");

        if (helpTipContent){
            var helpTip = new AJS.HelpTip({
                title: AJS.I18n.getText("jap.retention.period.help.tip.title"),
                bodyHtml: helpTipContent,
                anchor: $actionsButton,
                inlineDialogOpts: {
                    offsetY: 18,
                    width: 400
                }
            });

            helpTip.show();

            $actionsButton.on("click", function(){
                helpTip.dismiss();
            });
        }
    });
});
