define('jira/auditing/router', [
    'jira/auditing/router-helper',
    'backbone',
    'jquery'
], function(
    RouterHelper,
    Backbone,
    $
) {
    return Backbone.Router.extend({
        _isInitialRoute: true,
        routes: {
            "": "home",

            "page/:page": "searchWithoutFilterNoTopId",
            "page/:page/timevalue/:timeValue/timeunit/:timeUnit": "searchWithoutFilterWithTimeValueNoTopId",
            "page/:page/from/:fromDate/to/:toDate": "searchWithoutFilterWithDateRangeNoTopId",
            "search/:filter/page/:page": "genericSearchNoTopId",
            "search/:filter/page/:page/timevalue/:timeValue/timeunit/:timeUnit": "searchWithTimeValueNoTopId",
            "search/:filter/page/:page/from/:fromDate/to/:toDate": "searchWithDateRangeNoTopId",

            "page/:page/tid/:topId": "searchWithoutFilter",
            "page/:page/tid/:topId/timevalue/:timeValue/timeunit/:timeUnit": "searchWithoutFilterWithTimeValue",
            "page/:page/tid/:topId/from/:fromDate/to/:toDate": "searchWithoutFilterWithDateRange",
            "search/:filter/page/:page/tid/:topId": "genericSearch",
            "search/:filter/page/:page/tid/:topId/timevalue/:timeValue/timeunit/:timeUnit": "searchWithTimeValue",
            "search/:filter/page/:page/tid/:topId/from/:fromDate/to/:toDate": "searchWithDateRange"
        },
        initialize: function(options){
            this.collection = options.collection;
            this.mainView = options.mainView;
        },
        home: function(){
            this._isInitialRoute = false;

            // first time here - just save the current parameters
            if (typeof this._homeParams === "undefined"){
                this._homeParams = this.collection.getCurrentParams();
                this.mainView.render();
            } else {
                this.collection.setCurrentParams(this._homeParams);
                this.collection.pager();
            }
        },
        searchWithoutFilter: function(page, topId){
            this.search(null, page, topId);
        },
        searchWithoutFilterNoTopId: function(page){
            this.search(null, page);
        },
        searchWithoutFilterWithTimeValue: function(pageId, topId, timeValue, timeUnit){
            this.search(null, pageId, topId, timeValue, timeUnit, null, null);
        },
        searchWithoutFilterWithTimeValueNoTopId: function(pageId, timeValue, timeUnit){
            this.search(null, pageId, null, timeValue, timeUnit, null, null);
        },
        searchWithoutFilterWithDateRange: function(pageId, topId, fromDate, toDate){
            this.search(null, pageId, topId, null, null, fromDate, toDate);
        },
        searchWithoutFilterWithDateRangeNoTopId: function(pageId, fromDate, toDate){
            this.search(null, pageId, null, null, null, fromDate, toDate);
        },
        genericSearch: function(filter, page, topId){
            this.search(filter, page, topId, null, null, null, null);
        },
        genericSearchNoTopId: function(filter, page){
            this.search(filter, page, null, null, null, null, null);
        },
        searchWithTimeValue: function(filter, pageId, topId, timeValue, timeUnit){
            this.search(filter, pageId, topId, timeValue, timeUnit, null, null);
        },
        searchWithTimeValueNoTopId: function(filter, pageId, timeValue, timeUnit){
            this.search(filter, pageId, null, timeValue, timeUnit, null, null);
        },
        searchWithDateRange: function(filter, pageId, topId, fromDate, toDate){
            this.search(filter, pageId, topId, null, null, fromDate, toDate);
        },
        searchWithDateRangeNoTopId: function(filter, pageId, fromDate, toDate){
            this.search(filter, pageId, null, null, null, fromDate, toDate);
        },
        search: function(filter, page, topId, timeValue, timeUnit, fromDate, toDate){
            var params = {
                filter: filter || "",
                currentPage: page,
                topId: topId || undefined,
                timeUnitValue: timeValue || "",
                timeUnit: timeUnit || "",
                fromDate: fromDate || "",
                toDate: toDate || ""
            };

            var initial = this._isInitialRoute;
            this._isInitialRoute = false;

            // initial means the route has been triggered by Backbone.history
            if (initial){
                if (this.collection.hasExactParams(params)){
                    // collection is already populated exactly as it should be

                    this.collection.ensurePageAvailable();
                    this.mainView.render();
                    return;
                } else {
                    // if not, url contained / contains hash, and additional request is needed for
                    // collection to have records consistent with its params

                    this.mainView.renderWithThrobber();
                    this.collection.isInitialRequest = true;
                }
            }

            this.collection.setCurrentParams(params);
            this.collection.pager();
        },
        saveHistoryState: function(){
            var params = this.collection.getCurrentParams();
            var isHome = true;

            // check if current params are the same like homepage ones; if so, this means
            // we are on the homepage
            if (!this._homeParams){
                isHome = false;
            } else {
                $.each(this._homeParams, function(key, value){
                    if (params[key] !== value) isHome = false;
                });
            }

            // TODO: the mechanism here to recognize when the url should be replaced instead of being added should be more generic
            var url = isHome ? "" : RouterHelper.generateUrl(this.collection.getCurrentParamsEncoded());
            var replace = !!((this.collection.isRefreshing && !this.collection.topIdBeforeRefresh) || this.collection._ensuringPageAvailable);
            this.navigate(url, {replace: replace});
            this.collection.isRefreshing = false;
            this.collection._ensuringPageAvailable = false;
        }
    });
});

AJS.namespace('JIRA.Auditing.Router', null, require('jira/auditing/router'));
