define('jira/auditing/router-helper', [
    'jquery'
], function(
    $
) {
    // fragment - a literal appearing in properly formatted url
    // collectionKey - a name of the key used to store param in collection
    // requiresCollectionKey - if present, current fragment will appear only if the collection has non-empty required param
    var urlParams = [
        {fragment: "search", collectionKey: "filter"},
        {fragment: "page", collectionKey: "currentPage"},
        {fragment: "tid", collectionKey: "topId"},
        {fragment: "timevalue", collectionKey: "timeUnitValue", requiresCollectionKey: "timeUnit"},
        {fragment: "timeunit", collectionKey: "timeUnit", requiresCollectionKey: "timeUnitValue"},
        {fragment: "from", collectionKey: "fromDate"},
        {fragment: "to", collectionKey: "toDate"}
    ];

    return {
        // generate properly formatted auditing url
        generateUrl: function(params){
            var params = params || {};
            var url = "";

            $.each(urlParams, function(i, obj){
                var value = params[obj.collectionKey];
                var keyRequired = obj.requiresCollectionKey;

                if (keyRequired && !params[keyRequired]){
                    return;
                }

                if (value){
                    url += "/" + obj.fragment + "/" + value;
                }
            });

            return url;
        },

        // get params out of query string
        parseQueryParams: function(){
            var query = location.search.indexOf("?") === 0 ? location.search.substring(1) : location.search;
            var params = {};

            if (!query.length) return params;

            $.each(query.split("&"), function(i, pair){
                var data = pair.split("=");
                params[data[0]] = data[1];
            });

            return params;
        }
    };
});

AJS.namespace('JIRA.Auditing.RouterHelper', null, require('jira/auditing/router-helper'));
