define('jira/auditing/search-view', [
    'brace'
], function(
    Brace
) {
    return Brace.View.extend({

        el: ".search-container",

        events: {
            'submit form' : 'search'
        },

        $searchEntry: undefined,
        $searchButton: undefined,

        initialize: function() {
            this.$searchEntry = this.$(".search-entry");
            this.$searchButton = this.$('form').find('button');

            this.$searchEntry.val(this.collection.getCurrentParams().filter);

            this.collection.on("sync", this.onCollectionSync, this);
        },

        search: function(event) {
            event.preventDefault();
            this.collection.filter = this.$searchEntry.val();
            this.collection.trigger("auditing:refresh-records", {filter: this.$searchEntry.val()});
        },

        onCollectionSync: function(){
            this.$searchEntry.val(this.collection.filter);
        }
    });
});

AJS.namespace('JIRA.Auditing.SearchView', null, require('jira/auditing/search-view'));