define('jira/auditing/pagination-view', [
    'brace',
    'jquery'
], function(
    Brace,
    $
) {
    return Brace.View.extend({

        events: {
            'click .auditing-page-next': 'nextResultPage',
            'click .auditing-page-prev': 'previousResultPage',
            'click .auditing-page-link': 'goToPage',
            "click .auditing-refresh-link": "refreshRecords"
        },

        template: JIRA.Templates.Auditing.pagination,

        initialize: function () {
            this.render();
            this.collection.on("auditing:update-records-possible", this.render, this);

            $('a[title]', this.$el).tooltip();
        },

        stop: function () {
            $('a[original-title]', this.$el).each(function() {
                var $tooltip = $(this).data('tipsy');
                if ($tooltip) {
                    $tooltip.disable();
                    $tooltip.hide();
                }
            });
            this.undelegateEvents()
        },

        nextResultPage: function (e) {
            e.preventDefault();
            if (this.collection.info().next !== false) {
                this.collection.requestNextPage();
            }
        },

        previousResultPage: function (e) {
            e.preventDefault();
            if (this.collection.info().previous !== false) {
                this.collection.requestPreviousPage();
            }
        },

        goToPage: function (e) {
            e.preventDefault();
            this.collection.goTo($(e.target).text());
        },

        refreshRecords: function(e){
            e.preventDefault();
            this.collection.trigger("auditing:update-records");
        },

        render: function(){
            var params = this.collection.info() || {};
            params.size = this.collection.size();
            // don't show bottom refresh message if there's no pagination (collection is empty)
            params.refreshable = this.collection.isRefreshable() && (this.collection.size() ? true : !this.$el.hasClass("bottom"));

            this.$el.html(this.template(params));
            this.$el[params.refreshable ? "addClass" : "removeClass"]("auditing-refreshable");
        }

    });
});

AJS.namespace('JIRA.Auditing.PaginationView', null, require('jira/auditing/pagination-view'));
