define('jira/auditing/record', [
    'brace'
], function(
    Brace
) {
    return Brace.Model.extend({

        namedAttributes: [
            'id',
            'summary',
            'author',
            'gmtOffset',
            'timezone',
            'created',
            'category',
            'categoryId',
            'remoteAddr',
            'objectItem',
            'eventSource',
            'description',
            'changedValues',
            'associatedItems'],


        defaults: {
            summary: "",
            author: {
                fullName: ""
            },
            gmtOffset: "0",
            timezone: "",
            id: "",
            created: "",
            category: "",
            categoryId: "",
            remoteAddr: "",
            objectItem: {
                objectName: ""
            },
            eventSource: "",
            description: "",
            changedValues: [],
            associatedItems: []
        }
    });
});

AJS.namespace('JIRA.Auditing.Record', null, require('jira/auditing/record'));
