define('jira/auditing/time-filter-controller', [
    'jira/auditing/time-filter-view',
    'jquery'
], function(
    TimeFilterView,
    $
) {
    return function() {
        return {
            consts: {
                WITHIN_THE_LAST: "wtl",
                ALL_RECORDS: "all",
                BETWEEN: "btw"
            },
            model: {
                type: "all",
                unit: "minutes",
                unitValue: "",
                fromDate: "",
                toDate: ""
            },
            recordsCollections: null,
            view: null,

            init: function(args) {
                this.recordsCollections = args.collection;
                this._syncModelWithCollection();

                this.view = new TimeFilterView({
                    consts: this.consts,
                    model: this.model
                });
                this.view.on("auditing:update-time-filter-model", this.updateTimeFilterModel, this);
                this.view.render();

                this.recordsCollections.on("sync", this.onCollectionSync, this);
            },

            onCollectionSync: function(){
                this._syncModelWithCollection();

                this.view.refreshDialogFromModel();
                this.view.updateFilterDescription();
            },

            updateTimeFilterModel: function(event) {

                var splitFromVal,
                    splitToVal;

                //read radio
                this.model.type = $('input[name=auditDateFilter]:checked','#time-filter-form').val();
                //read input
                this._clearModel();

                if (this.model.type === this.consts.WITHIN_THE_LAST) {
                    this.model.unit = $('select.time-unit','#time-filter-form').val();
                    this.model.unitValue = $('input.time-unit-value','#time-filter-form').val();

                } else if (this.model.type === this.consts.BETWEEN) {
                    var splittedFrom = $('#from-date-picker').val().split("-");
                    this.model.fromDate = new Date(splittedFrom[0], splittedFrom[1]-1, splittedFrom[2]).getTime();

                    var splittedTo = $('#to-date-picker').val().split("-");
                    this.model.toDate = new Date(splittedTo[0], splittedTo[1]-1, splittedTo[2]).getTime();
                }

                this.view.updateFilterDescription();
                this.recordsCollections.trigger("auditing:refresh-records",
                    {
                        timeUnit: this.model.unit,
                        timeUnitValue: this.model.unitValue,
                        fromDate: this.model.fromDate,
                        toDate: this.model.toDate
                    }
                );
            },

            _clearModel: function() {
                this.model.unit = "";
                this.model.unitValue = "";
                this.model.fromDate = "";
                this.model.toDate = "";
            },

            _syncModelWithCollection: function(){
                var params = this.recordsCollections.getCurrentParams();

                this.model.unit = params.timeUnit;
                this.model.unitValue = params.timeUnitValue;
                this.model.fromDate = params.fromDate;
                this.model.toDate = params.toDate;

                if (this.model.unit && this.model.unitValue){
                    this.model.type = this.consts.WITHIN_THE_LAST;
                } else if (this.model.fromDate && this.model.toDate){
                    this.model.type = this.consts.BETWEEN;
                } else {
                    this.model.type = this.consts.ALL_RECORDS;
                }
            }
        }
    }
});

AJS.namespace('JIRA.Auditing.TimeFilterController', null, require('jira/auditing/time-filter-controller'));