/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.auditing.rest.responses;

import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugins.auditing.rest.responses.AssociatedItemResponse;
import com.atlassian.jira.plugins.auditing.rest.responses.ProjectResponse$;
import com.atlassian.jira.plugins.auditing.rest.responses.UserResponse;
import com.atlassian.jira.plugins.auditing.rest.responses.UserResponse$;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple5;
import scala.collection.immutable.StringOps;

public final class AssociatedItemResponse$
implements Serializable {
    public static final AssociatedItemResponse$ MODULE$;

    static {
        new AssociatedItemResponse$();
    }

    public AssociatedItemResponse fromAffectedObject(AssociatedItem ai) {
        String x$1 = ai.getObjectType().toString();
        String x$2 = ai.getObjectName();
        String x$3 = ai.getObjectId();
        String x$4 = ai.getParentName();
        Object x$5 = this.getAssociatedItemDetails(ai);
        return new AssociatedItemResponse(x$2, x$4, x$1, x$3, x$5);
    }

    public AssociatedItemResponse convertAssociatedItemToResponse(AssociatedItem ai) {
        if (ai == null) {
            return null;
        }
        String x$6 = ai.getObjectType().toString();
        String x$7 = ai.getObjectName();
        String x$8 = ai.getObjectId();
        String x$9 = ai.getParentName();
        Object x$10 = this.getAssociatedItemDetails(ai);
        return new AssociatedItemResponse(x$7, x$9, x$6, x$8, x$10);
    }

    public Object getAssociatedItemDetails(AssociatedItem associatedItem) {
        String name = associatedItem.getObjectType().name();
        if (name.equals(AssociatedItem.Type.USER.name())) {
            ApplicationUser user = ComponentAccessor.getUserManager().getUserByKeyEvenWhenUnknown(associatedItem.getObjectId());
            return this.getUserResponse(user);
        }
        if (name.equals(AssociatedItem.Type.PROJECT.name())) {
            Option<Project> projectOption = this.getProjectObject(associatedItem);
            return ProjectResponse$.MODULE$.createProjectResponse(projectOption, associatedItem.getObjectName(), associatedItem.getObjectId());
        }
        return null;
    }

    private Option<Project> getProjectObject(AssociatedItem associatedItem) {
        Option option;
        try {
            option = Option$.MODULE$.apply((Object)ComponentAccessor.getProjectManager().getProjectObj(Predef$.MODULE$.long2Long(new StringOps(Predef$.MODULE$.augmentString(associatedItem.getObjectId())).toLong())));
        }
        catch (Exception exception) {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    private UserResponse getUserResponse(ApplicationUser user) {
        return UserResponse$.MODULE$.User2UserResponse(user);
    }

    public AssociatedItemResponse apply(String objectName, String parentName, String objectType, String objectId, Object objectData) {
        return new AssociatedItemResponse(objectName, parentName, objectType, objectId, objectData);
    }

    public Option<Tuple5<String, String, String, String, Object>> unapply(AssociatedItemResponse x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)x$0.objectName(), (Object)x$0.parentName(), (Object)x$0.objectType(), (Object)x$0.objectId(), x$0.objectData()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private AssociatedItemResponse$() {
        MODULE$ = this;
    }
}

